/*	tvmthd.cxx

{{IS_NOTE

	Authors:	Tom M. Yeh
	Contributors:
	Create Date:	6/16/0 03:20PM
	$Header: /cvsroot/jedi/tvm/dll/tvmthd.cxx,v 1.7 2000/09/26 10:09:27 tomyeh Exp $
	Purpose:	Thread Implementation
	Description:
	
}}IS_NOTE

Copyright (C) 2000 Infoshock Corporation. All Rights Reserved.

{{IS_RIGHT
}}IS_RIGHT
*/
#include "StdAfx.h"
#include "tvmapp.h"

/////////////////////////////////////////////////////////////////
struct TThdCreateInfo {
	pthread_f	func;
	void		*param;
};

/////////////////////////////////////////////////////////////////
static unsigned __stdcall ThreadFunc(void* p)
{
	//copy pInfo into stack and delete it
	TThdCreateInfo info = *((TThdCreateInfo*)p);
	delete ((TThdCreateInfo*)p);

	(info.func)(info.param);

	return 0;
}

EXTERN_C TVM_API pthread_t _CDECL tvmCreateThread(
	pthread_f func, void *param, unsigned nStackSize, unsigned *pThdId)
{
	TThdCreateInfo* pInfo = new TThdCreateInfo;
	if(!pInfo){
		tvmMessage("Memory not enough\n");
		return 0;
	}
	pInfo->func  = func;
	pInfo->param = param;

	HANDLE hThd = (HANDLE)_beginthreadex(0, nStackSize, ThreadFunc, pInfo, 0, pThdId);

	if(!hThd){
		delete pInfo;
		tvmMessage("Failed to create a thread, %p\n", func);
		return 0;
	}

	return (pthread_t)hThd;
}

EXTERN_C TVM_API void _CDECL tvmDetachThread(pthread_t hThd)
{
	CloseHandle((HANDLE)hThd);
}

EXTERN_C TVM_API unsigned _CDECL tvmGetCurrentThreadId(void)
{
	return GetCurrentThreadId();
}

EXTERN_C TVM_API void _CDECL tvmExitThread(void)
{
	ExitThread(0);
}

EXTERN_C TVM_API void _CDECL tvmKillThread(pthread_t hThd)
{
	TerminateThread((HANDLE)hThd, 0);
}

EXTERN_C TVM_API void _CDECL tvmYield(void)
{
	Sleep(0);
}

EXTERN_C TVM_API void _CDECL tvmSleep(unsigned ticks)
{
	Sleep(ticks*10);
}

EXTERN_C TVM_API bool _CDECL tvmWaitThread(pthread_t hThd, unsigned toTicks)
{
	return WAIT_TIMEOUT!=WaitForSingleObject(
		(HANDLE)hThd, toTicks==TO_INFINITE ? INFINITE: toTicks*10);
}

EXTERN_C TVM_API bool _CDECL tvmSetThreadPriority(pthread_t hThd, int priority)
{
	return 0!=SetThreadPriority((HANDLE)hThd, priority + (THREAD_PRIORITY_NORMAL-SCHED_PRIORITY_NORMAL));
}

EXTERN_C TVM_API int _CDECL tvmGetThreadPriority(pthread_t hThd)
{
	return GetThreadPriority((HANDLE)hThd) - (THREAD_PRIORITY_NORMAL-SCHED_PRIORITY_NORMAL);
}

/////////////////////////////////////////////////////////////////
typedef struct tvmcond_t {
	HANDLE			event;
	pthread_mutex_t	*pMutex;
} tvmcond_t;

EXTERN_C TVM_API void _CDECL tvmInitMutex(pthread_mutex_t *pMutex)
{
	if(pMutex){
		*pMutex = (pthread_mutex_t)(new CRITICAL_SECTION);
		if(*pMutex)
			InitializeCriticalSection((CRITICAL_SECTION*)*pMutex);
	}
}

EXTERN_C TVM_API void _CDECL tvmDestroyMutex(pthread_mutex_t *pMutex)
{
	if(pMutex && *pMutex){
		DeleteCriticalSection((CRITICAL_SECTION*)*pMutex);
		delete (CRITICAL_SECTION*)*pMutex;
		*pMutex = 0;
	}
}

EXTERN_C TVM_API void _CDECL tvmLockMutex(pthread_mutex_t *pMutex)
{
	if(pMutex && *pMutex)
		EnterCriticalSection((CRITICAL_SECTION*)*pMutex);
}

EXTERN_C TVM_API void _CDECL tvmUnlockMutex(pthread_mutex_t *pMutex)
{
	if(pMutex && *pMutex)
		LeaveCriticalSection((CRITICAL_SECTION*)*pMutex);
}

EXTERN_C TVM_API void _CDECL tvmInitCond(pthread_cond_t *pCond, pthread_mutex_t *pMutex)
{
	ASSERT(pCond && pMutex);
	*pCond = (pthread_cond_t)(new tvmcond_t);
	if(*pCond){
		(*pCond)->pMutex = pMutex;
		(*pCond)->event  = CreateEvent(0, FALSE, FALSE, 0);
	}
}

EXTERN_C TVM_API void _CDECL tvmDestroyCond(pthread_cond_t *pCond)
{
	if(pCond && *pCond){
		CloseHandle((*pCond)->event);
		delete (tvmcond_t*)*pCond;
		*pCond = 0;
	}
}

EXTERN_C TVM_API void _CDECL tvmSetCond(pthread_cond_t *pCond)
{
	if(pCond && *pCond)
		SetEvent((*pCond)->event);
}

EXTERN_C TVM_API bool _CDECL tvmWaitCond(pthread_cond_t *pCond, unsigned toTicks)
{
	if(!pCond || !*pCond)
		return false;

	tvmUnlockMutex((*pCond)->pMutex);
	bool bOk = WAIT_OBJECT_0 ==
			WaitForSingleObject((*pCond)->event, toTicks==TO_INFINITE ? INFINITE: toTicks*10);
	tvmLockMutex((*pCond)->pMutex);
	return bOk;
}

/////////////////////////////////////////////////////////////////
EXTERN_C TVM_API unsigned _CDECL tvmAllocTls(void)
{
	return TlsAlloc();
}

EXTERN_C TVM_API BOOL _CDECL tvmFreeTls(unsigned index)
{
	return TlsFree(index);
}

EXTERN_C TVM_API void* _CDECL tvmGetTls(unsigned index)
{
	return TlsGetValue(index);
}

EXTERN_C TVM_API BOOL _CDECL tvmSetTls(unsigned index, void* val)
{
	return TlsSetValue(index, val);
}
