/*	tvmfb.h

{{IS_NOTE

	Authors:	Tom M. Yeh
	Contributors:
	Create Date:	6/21/0 11:27AM
	$Header: /cvsroot/jedi/tvm/dll/tvmfb.h,v 1.10 2000/10/11 09:22:52 tomyeh Exp $
	Purpose:	Frame buffer
	Description:
	
}}IS_NOTE

Copyright (C) 2000 Infoshock Corporation. All Rights Reserved.

{{IS_RIGHT
}}IS_RIGHT
*/
#ifndef _is_tvmfb_H
#define _is_tvmfb_H

#include "../../include/tvm/tvm.h"

typedef CList<RECT, RECT&> CFbUpdList;

/////////////////////////////////////////////////////////
//CFb
//
// CFb can be associated with a window, such that it will request the
// associated window to update when FbWrite is called.
// To associate:
// 1. Call Bind with a valid window (usually in WM_CREATE)
// 2. Call Draw when the window processes WM_PAINT

class CFb {
public:
	CFb();
	~CFb();

	/////////////////////////////////////////////
	//Frame buffer utilities
	HBITMAP Config(const struct tvm_info* ti, const unsigned colors[], unsigned *baseAddr);
	bool SetPalette(const unsigned colors[], int index, int nColors, bool bBigEndian);
		//bBigEndian: false if colors is little endian, true if big endian

	unsigned char GetScale() const {return m_tvmInfo.scale;}
	void SetScale(unsigned char v) {ASSERT(v>=1 && v<=3); m_tvmInfo.scale = v;}

	int Width() const {return m_tvmInfo.scrn_cx;}
	int Height() const {return m_tvmInfo.scrn_cy;}
	int WidthScale() const {return Width()*GetScale();}
	int HeightScale() const {return Height()*GetScale();}

	int BitPerPixel() const {return m_tvmInfo.bpp;}

	HBITMAP GetDIBSection() const {return m_hDIB;}

	HBITMAP Duplicate();
		//Duplicate the frame buffer to a global memory

	void Update(const RECT* rect);
		//if view is not null, the corresponding rectangle is invalidated

	/////////////////////////////////////////////
	//Synchronization utilities
	bool Bind(CWnd* view);

	void Draw(CDC& dc, const CRect* pRect =0);
		//draw this frame buffer on CDC

	inline bool IsSync() const {return m_bSync;}
	inline void SetSync(bool bSync) {m_bSync = bSync;}

protected:
	void Cleanup();
		//cleanup the memory use of the frame buffer

	static unsigned __stdcall UpdThdFunc(void*);
	void ProcessUpdList(); //called by UpdThdFunc

	//Data Members
	//frame-bufer-related members
	HBITMAP m_hDIB;
	struct tvm_info m_tvmInfo;

	__u8* m_fb;
	BITMAPINFO* m_bmi;

	//Synchronization-related members
	CWnd* m_view;
	CEvent m_hEvtExit;
	CEvent m_hEvtUpdAvail;
	CCriticalSection m_csUpdList, m_csDraw;
	CFbUpdList m_updList;
	bool m_bSync;
};

extern CFb g_tvmFb;

inline unsigned char GetScale() {return g_tvmFb.GetScale();}

#endif //_is_tvmfb_H
