/*	tvmapp.h

{{IS_NOTE

	Authors:	Tom M. Yeh
	Contributors:
	Create Date:	6/12/0 03:30PM
	$Header: /cvsroot/jedi/tvm/dll/tvmapp.h,v 1.6 2000/10/11 07:44:16 tomyeh Exp $
	Purpose:	Define CTvmApp
	Description:
	
}}IS_NOTE

Copyright (C) 2000 Infoshock Corporation. All Rights Reserved.

{{IS_RIGHT
}}IS_RIGHT
*/
#if !defined(AFX_TVM_H__516199A5_40D1_11D4_BC3F_0060089854CD__INCLUDED_)
#define AFX_TVM_H__516199A5_40D1_11D4_BC3F_0060089854CD__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#ifndef __AFXWIN_H__
	#error include 'stdafx.h' before including this file for PCH
#endif

#include "resource.h"		// main symbols

class CTraceFrame;
class CMainFrame;

/////////////////////////////////////////////////////////////////////////////
// CTvmApp
//

class CTvmApp : public CWinApp
{
public:
	CTvmApp();

	BOOL CreateTraceWnd();
	BOOL CreateMainWnd();
		//Note: to catch traces, we have to create trace window first
		//However, we show both trace and main windows in CreateMainWnd

	inline bool IsPaused() const {return m_bPaused;}
	inline void WaitIfPause() const {
		if(m_bPaused){//using m_bPaused to speed up
			::WaitForSingleObject(m_hEvtNotPause, INFINITE);
		}
	}
	inline void Pause() {
		m_hEvtNotPause.ResetEvent();
		m_bPaused = true;
	}
	inline void Resume() {
		m_hEvtNotPause.SetEvent();
		m_bPaused = false;
	}

	inline bool IsStopping() const {return m_bStopping;}
	inline bool InTrace() const {return m_bInTrace;}

	inline CMainFrame* GetMainWnd() const {return (CMainFrame*)m_pMainWnd;}
	inline CTraceFrame* GetTraceWnd() const {return m_pTraceWnd;}

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CTvmApp)
	public:
	virtual BOOL InitInstance();
	//}}AFX_VIRTUAL

// Implementation
public:
	//{{AFX_MSG(CTvmApp)
	afx_msg void OnAppAbout();
	afx_msg void OnViewTrace();
	afx_msg void OnUpdateViewTrace(CCmdUI* pCmdUI);
	afx_msg void OnViewTvm();
	afx_msg void OnDebugPause();
	afx_msg void OnUpdateDebugPause(CCmdUI* pCmdUI);
	afx_msg void OnDebugInfo();
	afx_msg void OnDebugAsync();
	afx_msg void OnUpdateDebugAsync(CCmdUI* pCmdUI);
	afx_msg void OnEditCopy();
	//}}AFX_MSG
	afx_msg void OnTvmBtn(UINT nId);
	DECLARE_MESSAGE_MAP()

//public data member
public:
	CTraceFrame* m_pTraceWnd;	

protected:
	CEvent	m_hEvtNotPause; //signaled if not-paused
	bool	m_bPaused;

public:
	bool	m_bInTrace, //tvmTrace is executing
			m_bStopping; //the program is exiting
};


/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

/////////////////////////////////////////////////////////////////////////////
//Global Functions/Variables
extern CTvmApp theApp;

#include "../../include/tvm/tvm.h"

//////////////////////////////////
//tvmError for fatal errors -- it must be a bug
//tvmMessage for error that can be ignore or shall be taken care by program
//Both messages are logged into the trace window
//--------------------------------
//tvmError is used to pop up a dialog for serious error, and
//give user a chance to abort
void tvmError(const char* fmt, ...);

//tvmMessage is used by TVM to show internal messages on Trace windows.
inline void tvmMessage(const char* fmt, ...)
{
	va_list valist;
	va_start(valist, fmt);
	tvmTrace("TVM: ", fmt, valist);
}

//tvmMessage is used by TVM to show internal messages on Trace windows.
inline void tvmTrace(const char* extra, const char* fmt, ...)
{
	va_list valist;
	va_start(valist, fmt);
	tvmTrace(extra, fmt, valist);
}

inline void tvmMessageUnexpect(const char* flnm, int lnno)
{
	tvmMessage("Unexpect error at %s, %d\n", flnm, lnno);
}
#define UNEXPECT_ERROR() tvmMessageUnexpect(__FILE__, __LINE__)

#endif // !defined(AFX_TVM_H__516199A5_40D1_11D4_BC3F_0060089854CD__INCLUDED_)
