/*	tvmapp.cxx

{{IS_NOTE

	Authors:	Tom M. Yeh
	Contributors:
	Create Date:	6/12/0 03:34PM
	$Header: /cvsroot/jedi/tvm/dll/tvmapp.cxx,v 1.8 2000/10/11 09:22:52 tomyeh Exp $
	Purpose:	Define CTvmApp
	Description:
	
}}IS_NOTE

Copyright (C) 2000 Infoshock Corporation. All Rights Reserved.

{{IS_RIGHT
}}IS_RIGHT
*/
#include "StdAfx.h"
#include "tvmapp.h"
#include "tvmfb.h"
#include "MainFrm.h"
#include "TraceFrm.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CTvmApp

BEGIN_MESSAGE_MAP(CTvmApp, CWinApp)
	//{{AFX_MSG_MAP(CTvmApp)
	ON_COMMAND(ID_APP_ABOUT, OnAppAbout)
	ON_COMMAND(ID_VIEW_TRACE, OnViewTrace)
	ON_UPDATE_COMMAND_UI(ID_VIEW_TRACE, OnUpdateViewTrace)
	ON_COMMAND(ID_VIEW_TVM, OnViewTvm)
	ON_COMMAND(ID_DEBUG_PAUSE, OnDebugPause)
	ON_UPDATE_COMMAND_UI(ID_DEBUG_PAUSE, OnUpdateDebugPause)
	ON_COMMAND(ID_DEBUG_INFO, OnDebugInfo)
	ON_COMMAND(ID_DEBUG_ASYNC, OnDebugAsync)
	ON_UPDATE_COMMAND_UI(ID_DEBUG_ASYNC, OnUpdateDebugAsync)
	ON_COMMAND(ID_EDIT_COPY, OnEditCopy)
	//}}AFX_MSG_MAP
	ON_COMMAND_RANGE(ID_TVM_BTN_FIRST, ID_TVM_BTN_LAST, OnTvmBtn)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CTvmApp construction

CTvmApp::CTvmApp()
: m_pTraceWnd(0),
m_hEvtNotPause(FALSE, TRUE), //manual event
m_bPaused(true), m_bInTrace(false), m_bStopping(false)
//Note: default is pause, which is ON until the main frame is created
{
}

BOOL CTvmApp::CreateTraceWnd()
{
	CTraceFrame* pTrace = new CTraceFrame;
	if(!pTrace){
		AfxMessageBox(IDP_MEMORY_NOT_ENOUGH);
		return FALSE;
	}

	m_pTraceWnd = pTrace;
	if(!pTrace->LoadFrame(IDR_TRACEFRAME,
			WS_OVERLAPPEDWINDOW | FWS_ADDTOTITLE, NULL, NULL)){
		AfxMessageBox("Failed to create the trace window");

		delete pTrace;
		m_pTraceWnd = 0;
		return FALSE;
	}

	//we don't show the trace window here
	return TRUE;
}

BOOL CTvmApp::CreateMainWnd()
{
	if(!m_pTraceWnd){
		AfxMessageBox("The trace window must be created before the main window");
		return FALSE;
	}

	CMainFrame* pFrame = new CMainFrame;
	if(!pFrame){
		AfxMessageBox(IDP_MEMORY_NOT_ENOUGH);
		return FALSE;
	}

	m_pMainWnd = pFrame;
	if(!pFrame->LoadFrame(IDR_MAINFRAME,
			WS_OVERLAPPEDWINDOW | FWS_ADDTOTITLE, NULL, NULL)){
		AfxMessageBox("Failed to create the main window");

		delete pFrame;
		m_pMainWnd = 0;
		return FALSE;
	}

	pFrame->FitWindowSize();

	m_pTraceWnd->ShowWindow(SW_SHOW);
	pFrame->ShowWindow(SW_SHOW);
	pFrame->UpdateWindow();
	pFrame->SetFocus();
	return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
// The one and only CTvmApp object

CTvmApp theApp;

/////////////////////////////////////////////////////////////////////////////
// CTvmApp initialization

BOOL CTvmApp::InitInstance()
{
	if (!AfxSocketInit())
	{
		AfxMessageBox(IDP_SOCKETS_INIT_FAILED);
		return FALSE;
	}

	return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
		// No message handlers
	//}}AFX_MSG
//	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

//BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
//END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CTvmApp message handlers

void CTvmApp::OnAppAbout() 
{
	CAboutDlg aboutDlg;
	aboutDlg.DoModal();
}

void CTvmApp::OnViewTrace() 
{
	m_pTraceWnd->ShowWindow(m_pTraceWnd->IsWindowVisible() ? SW_HIDE: SW_SHOWNA);
}

void CTvmApp::OnUpdateViewTrace(CCmdUI* pCmdUI) 
{
	pCmdUI->SetCheck(m_pTraceWnd->IsWindowVisible());
}

void CTvmApp::OnViewTvm() 
{
	m_pMainWnd->SetForegroundWindow();	
}

void CTvmApp::OnDebugPause() 
{
	if(m_bPaused){
		Resume();
		tvmMessage("resumed\n");
	}else{
		Pause();
		tvmMessage("paused\n");
	}
}

void CTvmApp::OnTvmBtn(UINT /*nId*/)
{
	m_pMainWnd->SetForegroundWindow();
	//not yet
}

void CTvmApp::OnDebugInfo() 
{
	const char* seps = "===================================\n";
	tvmTrace(">>", seps);
	tvmTrace(0, "Resolution: %d x %d, bpp %d, zoom 1:%d\n",
		g_tvmFb.Width(), g_tvmFb.Height(), g_tvmFb.BitPerPixel(),
		g_tvmFb.GetScale());

	if(IsPaused())
		tvmTrace(0, "Display is paused\n");

	tvmTrace("<<", seps);
}

void CTvmApp::OnUpdateDebugPause(CCmdUI* pCmdUI) 
{
	pCmdUI->SetCheck(IsPaused());	
}

void CTvmApp::OnDebugAsync() 
{
	g_tvmFb.SetSync(!g_tvmFb.IsSync());
}

void CTvmApp::OnUpdateDebugAsync(CCmdUI* pCmdUI) 
{
	pCmdUI->SetCheck(!g_tvmFb.IsSync());	
}

void CTvmApp::OnEditCopy() 
{
	bool bOk = false;
	if(OpenClipboard(0)){
		if(EmptyClipboard()){
			HBITMAP hbmp = g_tvmFb.Duplicate();
			if(hbmp){
				if(SetClipboardData(CF_BITMAP, hbmp))
					bOk = true;
				else
					DeleteObject(hbmp);
			}
		}
		CloseClipboard();
	}

	if(!bOk)
		AfxMessageBox("Failed to copy screen to clipboard");
}
