/*	tvm.cxx

{{IS_NOTE

	Authors:	Tom M. Yeh
	Contributors:
	Create Date:	6/13/0 04:28PM
	$Header: /cvsroot/jedi/tvm/dll/tvm.cxx,v 1.16 2000/10/12 09:15:04 tomyeh Exp $
	Purpose:	tvmInit, tvmStart, tvmTrace
	Description:
	
}}IS_NOTE

Copyright (C) 2000 Infoshock Corporation. All Rights Reserved.

{{IS_RIGHT
}}IS_RIGHT
*/
#include "StdAfx.h"
#include <malloc.h>
#include "tvmapp.h"
#include "tvmfb.h"
#include "MainFrm.h"
#include "TraceFrm.h"

///////////////////////////////////////////////////////////////
static void (*s_pfAbort)(void);
void (*g_pfHwNotify)(int evt, unsigned param1, unsigned param2);

///////////////////////////////////////////////////////////////
//Initial
EXTERN_C TVM_API bool _CDECL tvmInit(
	void (*notifyfn)(int evt,unsigned param1, unsigned param2),
	void (*abortfn)(void))
{
	//already inited?
	if(theApp.GetMainWnd()){
		AfxMessageBox(IDP_TVM_ALREADY_INITED);
		return false;
	}

	//set up notify
	if(!notifyfn){
		AfxMessageBox("The notify function is not specified");
		return false;
	}
	g_pfHwNotify = notifyfn;

	//set up abort
	if(!abortfn){
		AfxMessageBox("The abort function is not specified");
		return false;
	}
	s_pfAbort = abortfn;

	return theApp.CreateTraceWnd()!=0;
		//we have to create trace window first, so message will be logged

	//Note: we cannot create main frame here because it needs
	//the information of framebuffer which is unknown now
}

EXTERN_C TVM_API bool _CDECL tvmStart(void)
{
	if(theApp.GetMainWnd()){
		AfxMessageBox(IDP_TVM_ALREADY_INITED);
		return false;
	}

	//create main frame
	bool bOk = theApp.CreateMainWnd()!=0;
	if(bOk){
		theApp.GetMainWnd()->UpdateWindow();
		ASSERT(theApp.IsPaused());
		theApp.Resume();
		theApp.Run();
	}

	return bOk;
}

////////////////////////////////////////////////////////////////////////
EXTERN_C TVM_API unsigned _CDECL tvmGetCurrentTicks(void)
{
	return GetTickCount() / 10; //1/100 sec
}

////////////////////////////////////////////////////////////////////////
//Trace
EXTERN_C TVM_API void 
_CDECL tvmTrace(const char* extra, const char* fmt, va_list valist)
{
	theApp.m_bInTrace = true;
	if(!theApp.IsStopping() && theApp.m_pTraceWnd){
		if(extra)
			theApp.m_pTraceWnd->m_wndView.PostMessage(WM_ADDTEXT, (WPARAM)strdup(extra), 0);

		if(fmt){
			char* buf = (char*)malloc(4000);
			if(buf){
				vsprintf(buf, fmt, valist);
				theApp.m_pTraceWnd->m_wndView.PostMessage(WM_ADDTEXT, (WPARAM)buf, 0);
			}
		}
	}
	theApp.m_bInTrace = false;
}

void tvmError(const char* fmt, ...)
{
	va_list valist;
	va_start(valist, fmt);
	tvmTrace("TVM Error: ", fmt, valist);

	if(IDCANCEL==MessageBox(0,
			"An fatal error occurs, refer to the trace window. "
			"Press Cancel to abort.", "TVM",
			MB_ICONSTOP|MB_OKCANCEL))
		s_pfAbort();
}

////////////////////////////////////////////////////////////////////////
EXTERN_C TVM_API void* _CDECL tvmAlloc(unsigned sz)
{
	return malloc(sz);
}

EXTERN_C TVM_API void* _CDECL tvmRealloc(void* p, unsigned sz)
{
	return realloc(p, sz);
}

EXTERN_C TVM_API void _CDECL tvmFree(void* p)
{
	free(p);
}

EXTERN_C TVM_API unsigned _CDECL tvmMSize(void* p)
{
	return _msize(p);
}

EXTERN_C TVM_API void _CDECL tvmMemInfo(
	unsigned *szRom, unsigned *szRam, unsigned *szRamAvail)
{	//fake
	if(szRom) *szRom = 0x400000;
	if(szRam) *szRom = 0x800000;
	if(szRamAvail) *szRamAvail = 0x400000;
}

EXTERN_C TVM_API void _CDECL tvmNotifyNoApp(void)
{
	tvmTrace(0, ">>>> application stopped <<<<\n");
}

////////////////////////////////////////////////////////////////////////
EXTERN_C TVM_API _tvmDll_t tvmDllOpen(const char* name)
{
	tvmTrace(0, "Loading %s\n", name);
	return (_tvmDll_t)LoadLibrary(name);
}

EXTERN_C TVM_API void tvmDllClose(_tvmDll_t dll)
{
	FreeLibrary((HINSTANCE)dll);
}

EXTERN_C TVM_API _tvmDll_f tvmDllGet(_tvmDll_t dll, const char* name)
{
	return (_tvmDll_f)GetProcAddress((HINSTANCE)dll, name);
}
