/*	TraceView.cxx

{{IS_NOTE

	Authors:	Tom M. Yeh
	Contributors:
	Create Date:	6/13/0 10:08PM
	$Header: /cvsroot/jedi/tvm/dll/TraceView.cxx,v 1.3 2000/06/23 07:00:35 tomyeh Exp $
	Purpose:	CTraceView
	Description:
	
}}IS_NOTE

Copyright (C) 2000 Infoshock Corporation. All Rights Reserved.

{{IS_RIGHT
}}IS_RIGHT
*/
#include "StdAfx.h"

#include <malloc.h>
#include <io.h>
#include <fcntl.h>
#include <sys/stat.h>

#include "tvmapp.h"
#include "TraceFrm.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CTraceView

CTraceView::CTraceView()
{
}

CTraceView::~CTraceView()
{
}


BEGIN_MESSAGE_MAP(CTraceView, CEdit)
	//{{AFX_MSG_MAP(CTraceView)
	ON_COMMAND(ID_EDIT_CLEAR, OnEditClear)
	ON_COMMAND(ID_EDIT_CLEAR_ALL, OnEditClearAll)
	ON_COMMAND(ID_EDIT_COPY, OnEditCopy)
	ON_COMMAND(ID_EDIT_COPY_ALL, OnEditCopyAll)
	ON_COMMAND(ID_EDIT_CUT, OnEditCut)
	ON_COMMAND(ID_EDIT_FIND, OnEditFind)
	ON_COMMAND(ID_EDIT_SELECT_ALL, OnEditSelectAll)
	ON_COMMAND(ID_EDIT_UNDO, OnEditUndo)
	ON_MESSAGE(WM_ADDTEXT, OnAddText)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CTraceView diagnostics

#ifdef _DEBUG
void CTraceView::AssertValid() const
{
	CEditView::AssertValid();
}

void CTraceView::Dump(CDumpContext& dc) const
{
	CEditView::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CTraceView message handlers

void CTraceView::OnEditClear() 
{
	Clear();	
}

void CTraceView::OnEditClearAll() 
{
	SetSel(0,-1);
	Clear();
}

void CTraceView::OnEditCopy() 
{
	Copy();
}

void CTraceView::OnEditCopyAll() 
{
	int s,e;
	GetSel(s, e);
	SetSel(0, -1);
	Copy();
	SetSel(s, e);
}

void CTraceView::OnEditCut() 
{
	Cut();
}

void CTraceView::OnEditFind() 
{
	AfxMessageBox(IDP_NOT_YET_IMPLEMENTED);
}

void CTraceView::OnEditSelectAll() 
{
	SetSel(0,-1);
}

void CTraceView::OnEditUndo() 
{
	Undo();
}

static int write(int fd, const char* s)
{
	return _write(fd, s, strlen(s));
}

LRESULT CTraceView::OnAddText(WPARAM wp, LPARAM)
{
	char* s = (char*)wp;

	//write to log file
	static char flnm[128] ={0};
	int oflags = _O_APPEND|_O_CREAT|_O_WRONLY;
	bool bFirst = false;
	if(!flnm[0]){
		bFirst = true;

		//prepare filename
		char* s1 = getenv("TEMP");
		if(!s1) s1= "";
		char* s2 = getenv("USERNAME");
		if(!s2) s2 = "";

		int len1 = strlen(s1);
		sprintf(flnm,
			!len1 || s1[len1-1]=='\\' ? "%stvm_%s.log" : "%s\\tvm_%s.log",
			s1, s2);

		//check whether the file is too big
		struct _stat st;
		if(!_stat(flnm, &st) && st.st_size > 10000000)
			oflags |= _O_TRUNC;
	}

	int fd = _open(flnm, oflags, _S_IREAD|_S_IWRITE);
	if(fd<0){
		if(bFirst){
			char buf[256];
			sprintf(buf, "Failed to open logfile, %s\n", flnm);
			AddText(buf);
		}
	}else{
		if(bFirst){
			write(fd, "\n>>>>>>>>>>>>>> ");
			write(fd, flnm);
			write(fd, " <<<<<<<<<<<<<<\n");

			CTime time = CTime::GetCurrentTime();
			char buf[80];
			sprintf(buf, "%d/%d/%d %d:%d:%d\n------------------\n",
				time.GetYear(), time.GetMonth(), time.GetDay(),
				time.GetHour(), time.GetMinute(), time.GetSecond());
			write(fd, buf);
		}
		write(fd, s);
		_close(fd);
	}

	//put to the trace window
	if(GetLimitText() < (unsigned)GetWindowTextLength()+2000){
		//too many trace, we have to remove some
		SetSel(0, 4000, TRUE);
		ReplaceSel("", FALSE);
	}

	for(char* p = s; *p; ){
		bool bEOL = false;
		for(char *q = p; *q; ++q){
			if(q[0]=='\r' && q[1]=='\n')
				++q;
			else if(q[0]=='\n' || q[0]=='\r'){
				q[0] = 0;
				bEOL = true;
				break;
			}
		}

		AddText(p);
		if(bEOL){
			p = q+1;
			AddText("\r\n");
		}else
			break; //done
	}

	free(s);
	return 0;
}
