/*	ThumbView.cxx

{{IS_NOTE

	Authors:	Tom M. Yeh
	Contributors:
	Create Date:	6/13/0 04:02PM
	$Header: /cvsroot/jedi/tvm/dll/ThumbView.cxx,v 1.8 2000/10/11 09:22:52 tomyeh Exp $
	Purpose:	CThumbView
	Description:
	
}}IS_NOTE

Copyright (C) 2000 Infoshock Corporation. All Rights Reserved.

{{IS_RIGHT
}}IS_RIGHT
*/
#include "StdAfx.h"
#include "tvmapp.h"
#include "tvmfb.h"
#include "ThumbView.h"

#include "../../include/jedi/evtconst.h"

extern void (*g_pfHwNotify)(int evt, unsigned param1, unsigned param2);

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CThumbView

CThumbView::CThumbView()
{
}

CThumbView::~CThumbView()
{
}


BEGIN_MESSAGE_MAP(CThumbView, CWnd)
	//{{AFX_MSG_MAP(CThumbView)
	ON_WM_PAINT()
	ON_WM_KEYDOWN()
	ON_WM_CREATE()
	ON_WM_CHAR()
	ON_WM_LBUTTONDBLCLK()
	ON_WM_LBUTTONDOWN()
	ON_WM_LBUTTONUP()
	ON_WM_MOUSEMOVE()
	ON_WM_KEYUP()
	ON_WM_DESTROY()
	//}}AFX_MSG_MAP
	ON_COMMAND_RANGE(ID_TVM_BTN_FIRST, ID_TVM_BTN_LAST, OnTvmButtons)
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CThumbView message handlers

BOOL CThumbView::PreCreateWindow(CREATESTRUCT& cs) 
{
	if (!CWnd::PreCreateWindow(cs))
		return FALSE;

	cs.dwExStyle |= WS_EX_CLIENTEDGE;
	cs.style &= ~WS_BORDER;
	cs.lpszClass = AfxRegisterWndClass(CS_HREDRAW|CS_VREDRAW|CS_DBLCLKS, 
		::LoadCursor(NULL, IDC_ARROW), 0, NULL);

	return TRUE;
}

int CThumbView::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CWnd::OnCreate(lpCreateStruct) == -1)
		return -1;

	g_tvmFb.Bind(this);
	return 0;	
}

void CThumbView::OnPaint() 
{
	CPaintDC dc(this); // device context for painting
	g_tvmFb.Draw(dc);
}

static int _STDCALL ConvertKey(int nKey)
{
	//h/w button
	if(nKey==VK_PRIOR)
		return CC_PAGEUP;

	if(nKey==VK_NEXT)
		return CC_PAGEDOWN;

	if(nKey>=0xc1 && nKey<=0xc4) //h/w button
		return nKey - 0xc1 + CC_BTN1;

	//other keys
	static __u8 s_map[] = {CC_LEFT, CC_UP, CC_RIGHT, CC_DOWN};

	return	nKey==VK_CONTROL ? CC_COMMAND: //open command bar window
			nKey>=VK_LEFT && nKey<=VK_DOWN ?
				s_map[nKey-VK_LEFT]: 0;
}

void CThumbView::OnKeyDown(UINT nChar, UINT /*nRepCnt*/, UINT /*nFlags*/) 
{
	nChar = ConvertKey(nChar);
	if(nChar)
		g_pfHwNotify(EVT_KEYDOWN, nChar, 0);
}

void CThumbView::OnKeyUp(UINT nChar, UINT /*nRepCnt*/, UINT /*nFlags*/)
{
	nChar = ConvertKey(nChar);
	if(nChar)
		g_pfHwNotify(EX_EVT_KEYUP, nChar, 0);
}

void CThumbView::OnTvmButtons(UINT nId) 
{
	static short ccs[] = {
		CC_BTNPOWER, CC_UP, CC_DOWN, CC_LEFT, CC_RIGHT,
		CC_BTN1, CC_BTN2, CC_BTN3, CC_BTN4, CC_BTNCRADLE
	};
	g_pfHwNotify(EVT_KEYDOWN, ccs[nId - ID_TVM_BTN_FIRST], 0);
}

void CThumbView::OnChar(UINT nChar, UINT /*nRepCnt*/, UINT /*nFlags*/)
{
	g_pfHwNotify(EVT_KEYDOWN, nChar==VK_RETURN ? CC_LINEFEED: nChar, 0);
}

void CThumbView::OnLButtonDblClk(UINT /*nFlags*/, CPoint point) 
{
	SetCapture();
	g_pfHwNotify(EX_EVT_PENDOWN+1, point.x/GetScale(), point.y/GetScale());
}

void CThumbView::OnLButtonDown(UINT /*nFlags*/, CPoint point) 
{
	SetCapture();
	g_pfHwNotify(EX_EVT_PENDOWN, point.x/GetScale(), point.y/GetScale());
}

void CThumbView::OnLButtonUp(UINT /*nFlags*/, CPoint point) 
{
	ReleaseCapture();
	g_pfHwNotify(EVT_PENUP, point.x/GetScale(), point.y/GetScale());
}

void CThumbView::OnMouseMove(UINT nFlags, CPoint point) 
{
	if(nFlags & MK_LBUTTON)
		g_pfHwNotify(EVT_PENMOVE, point.x/GetScale(), point.y/GetScale());
}

void CThumbView::OnDestroy() 
{
	g_pfHwNotify(EVT_APPSTOP, 0, 0);
}
