/*	MainFrm.cxx

{{IS_NOTE

	Authors:	Tom M. Yeh
	Contributors:
	Create Date:	6/13/0 04:12PM
	$Header: /cvsroot/jedi/tvm/dll/MainFrm.cxx,v 1.5 2000/10/11 07:44:16 tomyeh Exp $
	Purpose:	CMainFrame
	Description:
	
}}IS_NOTE

Copyright (C) 2000 Infoshock Corporation. All Rights Reserved.

{{IS_RIGHT
}}IS_RIGHT
*/
#include "StdAfx.h"
#include "tvmapp.h"
#include "tvmfb.h"
#include "MainFrm.h"
#include "TraceFrm.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CMainFrame

IMPLEMENT_DYNAMIC(CMainFrame, CFrameWnd)

BEGIN_MESSAGE_MAP(CMainFrame, CFrameWnd)
	//{{AFX_MSG_MAP(CMainFrame)
	ON_WM_CREATE()
	ON_WM_SETFOCUS()
	ON_WM_GETMINMAXINFO()
	ON_WM_ACTIVATE()
	ON_WM_CLOSE()
	//}}AFX_MSG_MAP
	ON_COMMAND_RANGE(ID_VIEW_SCALE0, ID_VIEW_SCALE_LAST, OnViewScale)
	ON_UPDATE_COMMAND_UI_RANGE(ID_VIEW_SCALE0, ID_VIEW_SCALE_LAST, OnUpdateViewScale)
END_MESSAGE_MAP()

static UINT indicators[] =
{
	ID_SEPARATOR,           // status line indicator
	ID_INDICATOR_CAPS,
	ID_INDICATOR_NUM,
	ID_INDICATOR_SCRL,
};

/////////////////////////////////////////////////////////////////////////////
// CMainFrame construction/destruction

CMainFrame::CMainFrame()
{
}

CMainFrame::~CMainFrame()
{
}

BOOL CMainFrame::PreCreateWindow(CREATESTRUCT& cs) 
{
	if( !CFrameWnd::PreCreateWindow(cs) )
		return FALSE;

	cs.dwExStyle &= ~WS_EX_CLIENTEDGE;
	//Fix a bug of class wizard
	//cs.lpszClass = AfxRegisterWndClass(0);
	return TRUE;
}

int CMainFrame::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CFrameWnd::OnCreate(lpCreateStruct) == -1)
		return -1;
	
	// create a view to occupy the client area of the frame
	if (!m_wndView.Create(NULL, NULL, AFX_WS_DEFAULT_VIEW,
		CRect(0, 0, 0, 0), this, AFX_IDW_PANE_FIRST, NULL))
	{
		TRACE0("Failed to create view window\n");
		return -1;
	}
	
	if (!m_wndToolBar.CreateEx(this, TBSTYLE_FLAT, WS_CHILD | WS_VISIBLE | CBRS_TOP
		| CBRS_GRIPPER | CBRS_TOOLTIPS | CBRS_FLYBY | CBRS_SIZE_DYNAMIC) ||
		!m_wndToolBar.LoadToolBar(IDR_MAINFRAME))
	{
		TRACE0("Failed to create toolbar\n");
		return -1;      // fail to create
	}

	if (!m_wndStatusBar.Create(this) ||
		!m_wndStatusBar.SetIndicators(indicators,
		  sizeof(indicators)/sizeof(UINT)))
	{
		TRACE0("Failed to create status bar\n");
		return -1;      // fail to create
	}

	m_wndToolBar.EnableDocking(CBRS_ALIGN_ANY);
	EnableDocking(CBRS_ALIGN_ANY);
	DockControlBar(&m_wndToolBar);

	return 0;
}

/////////////////////////////////////////////////////////////////////////////
// CMainFrame message handlers

BOOL CMainFrame::OnCmdMsg(UINT nID, int nCode, void* pExtra, AFX_CMDHANDLERINFO* pHandlerInfo) 
{
	if (m_wndView.OnCmdMsg(nID, nCode, pExtra, pHandlerInfo))
		return TRUE;

	return CFrameWnd::OnCmdMsg(nID, nCode, pExtra, pHandlerInfo);
}

void CMainFrame::OnSetFocus(CWnd* /*pOldWnd*/) 
{
	m_wndView.SetFocus();
}

void CMainFrame::PostNcDestroy() 
{
	if(theApp.m_pTraceWnd)
		theApp.m_pTraceWnd->DestroyWindow();
		//keep trace window alive until main frame is stopped

	AfxPostQuitMessage(0);
		//MFC won't post WM_QUIT for DLL's main window, so we have to

	CFrameWnd::PostNcDestroy();
	theApp.m_pMainWnd = 0;
}

static int GetBarHeight(CControlBar* pBar)
{
	int hgh = 0;
	if(pBar->m_hWnd){
		CRect rc;
		pBar->GetWindowRect(&rc);
		hgh = rc.Height();
		if(!hgh){
			//Note: height is zero when a control bar is invisible
			//so we have to force it to calculate
			CSize sz = pBar->CalcFixedLayout(TRUE, TRUE);
			hgh = sz.cy;
		}
		--hgh; //MFC seems to overlap toolbar with one pixel
	}
	return hgh;
}

void CMainFrame::CalcMaxWindowSize(RECT* pRect)
{
	pRect->left = pRect->top = 0;
	pRect->right = g_tvmFb.WidthScale();
	pRect->bottom = g_tvmFb.HeightScale();

	AdjustWindowRectEx(pRect, GetWindowLong(m_hWnd, GWL_STYLE), 
		true, GetWindowLong(m_hWnd, GWL_EXSTYLE));

	pRect->bottom += GetBarHeight(&m_wndToolBar) 
						+ GetBarHeight(&m_wndStatusBar);

	if(m_wndView.m_hWnd){
		//add the NC area to pRect
		CRect rc;
		SetRectEmpty(&rc);
		AdjustWindowRectEx(&rc, GetWindowLong(m_wndView.m_hWnd, GWL_STYLE), 
			false, GetWindowLong(m_wndView.m_hWnd, GWL_EXSTYLE));
		pRect->right += rc.Width();
		pRect->bottom += rc.Height();
	}
	if(g_tvmFb.GetScale()==1)
		pRect->bottom += GetSystemMetrics(SM_CYMENU)-1;
			//in this case, the menu will wrap to two lines
}

void CMainFrame::FitWindowSize()
{
	CRect rc1, rc2;
	GetWindowRect(&rc1);
	CalcMaxWindowSize(&rc2);
	rc1.right = rc1.left + rc2.Width();
	rc1.bottom = rc1.top + rc2.Height();
	MoveWindow(&rc1);

	theApp.GetTraceWnd()->GetWindowRect(&rc2);
	int x = rc1.right;
	int wd = rc2.Width();
	if(wd > 450)
		wd = 450;

	int scrnwd = GetSystemMetrics(SM_CXFULLSCREEN);
	if(x + wd > scrnwd)
		if(scrnwd > x + 250){
			wd = scrnwd - x;
		}else{
			x = 0;
			wd = rc1.left;
		}

	theApp.GetTraceWnd()->MoveWindow(x, rc1.top, wd, rc1.Height());
}

void CMainFrame::OnGetMinMaxInfo(MINMAXINFO FAR* lpMMI) 
{
	CFrameWnd::OnGetMinMaxInfo(lpMMI);

	CRect rect;
	CalcMaxWindowSize(&rect);

	//lpMMI->ptMinTrackSize.x = //umark if not allowed to shrink
	lpMMI->ptMaxSize.x = lpMMI->ptMaxTrackSize.x = rect.Width();
	//lpMMI->ptMinTrackSize.y = //unmark if not allowed to shrink
	lpMMI->ptMaxSize.y = lpMMI->ptMaxTrackSize.y = rect.Height();
}

void CMainFrame::OnActivate(UINT nState, CWnd* pWndOther, BOOL bMinimized)
{
	CFrameWnd::OnActivate(nState, pWndOther, bMinimized);

	if(nState != WA_INACTIVE)
		theApp.m_pTraceWnd->SetWindowPos(this,0,0,0,0,SWP_NOMOVE|SWP_NOSIZE|SWP_NOACTIVATE);
}

void CMainFrame::OnViewScale(UINT nId)
{
	ASSERT(nId>=ID_VIEW_SCALE0 && nId<=ID_VIEW_SCALE_LAST);

	unsigned scale = (nId - ID_VIEW_SCALE0)+1;
	if(scale != g_tvmFb.GetScale()){
		g_tvmFb.SetScale((unsigned char)scale);

		FitWindowSize();
	}
}

void CMainFrame::OnUpdateViewScale(CCmdUI* pCmdUI)
{
	pCmdUI->SetCheck((int)(pCmdUI->m_nID - ID_VIEW_SCALE0+1) == g_tvmFb.GetScale());
}

void CMainFrame::OnClose() 
{
	theApp.m_bStopping = true;
	for(int j=0; theApp.InTrace() && ++j<32;)
		Sleep(2);
	
	CFrameWnd::OnClose();
}
