/* 
 *  COPYRIGHT (c) 1989-1997.
 *  On-Line Applications Research Corporation (OAR).
 *  Copyright assigned to U.S. Government, 1994.
 *
 *  The license and distribution terms for this file may be found in
 *  the file LICENSE in this distribution or at
 *  http://www.OARcorp.com/rtems/license.html.
 *
 *  $Id: init.c,v 1.2 1999/08/20 19:37:42 joel Exp $
 */

#include <bsp.h>

#include <assert.h>
#include <pthread.h>

#include <sys/stat.h>
#include <sys/types.h>
#include <fcntl.h>
#include <unistd.h>

extern rtems_configuration_table  BSP_Configuration;

/*
 *  By having the POSIX_Init thread create a second thread just
 *  to invoke XXX_main, we can override all default attributes
 *  of the "OpenPalm environment task".  Otherwise, we would be
 *  stuck with the defaults set by RTEMS.
 */
 
void *start_openpalm_main( void * argument )
{
  extern int openpalm_main ( int argc, char **argv, char **envp );

  (void) openpalm_main ( 0, 0, 0 );

  exit( 0 );

  return 0;
}

void *POSIX_Init( void *argument )
{
  pthread_t       thread_id;
  pthread_attr_t  attr;
  size_t          stacksize = _ada_pthread_minimum_stack_size();
  int             status;

  status = pthread_attr_init( &attr );
  assert( !status );

#define GNAT_MAIN_STACKSPACE 100
#ifdef GNAT_MAIN_STACKSPACE
  stacksize = GNAT_MAIN_STACKSPACE * 1024;
#else
#define GNAT_MAIN_STACKSPACE 0
#endif

  /* for file oriented tests */
  mkdir( "/tmp", 0777 );

  status = pthread_attr_setstacksize( &attr, stacksize );
  assert( !status );

  status = pthread_create( &thread_id, &attr, start_openpalm_main, NULL );
  assert( !status );

  pthread_exit( 0 );

  return 0;
}

/* configuration information */

#define CONFIGURE_TEST_NEEDS_CONSOLE_DRIVER
#define CONFIGURE_TEST_NEEDS_CLOCK_DRIVER

#define CONFIGURE_MICROSECONDS_PER_TICK RTEMS_MILLISECONDS_TO_MICROSECONDS(1)

/* ACATS needs to be able to create files */
#define CONFIGURE_USE_IMFS_AS_BASE_FILESYSTEM
#define CONFIGURE_LIBIO_MAXIMUM_FILE_DESCRIPTORS 20

#define CONFIGURE_POSIX_INIT_THREAD_TABLE

#define CONFIGURE_MAXIMUM_POSIX_THREADS 20

#define CONFIGURE_INIT

#include <confdefs.h>


/* stubs just to link OpenPalm */

#include <assert.h>
#include <sys/time.h>
#include <unistd.h>

int settimeofday(const struct timeval *tv ,  const  struct timezone *tz)
{
  printk("settimeofday -- NOT IMPLEMENTED!!");
  rtems_fatal_error_occurred(0xa5a5a5a5);
  return 0;
}

