/*	gui.cxx

{{IS_NOTE

	Authors:	Henri Chen
	Contributors:
	Create Date:	2000/7/27 03:22PM
	$Header: /cvsroot/jedi/test/gui.cxx,v 1.12 2000/10/05 07:22:15 henrichen Exp $
	Purpose:	
	Description:	Test code for Jedi's gui system

}}IS_NOTE

Copyright (C) 2000 Infoshock Corporation. All Rights Reserved.

{{IS_RIGHT
}}IS_RIGHT
*/
#include <jedi/kernel.h>
#include <jedi/debug.h>
#include <jedi/fb.h>
#include <jedi/thread.h>
#include <jedi/mem.h>
#include <jedi/rct.h>
#include <jedi/fnt.h>
#include <jedi/bmp.h>
#include <jedi/win.h>
#include <jedi/gdi.h>

void TestGUI(void)
{
	TRACEL(0, "MainThread...\n");

	//fb
	int nBytes = (SCREEN_WIDTH*SCREEN_HEIGHT*SCREEN_BPP) >> 3;
	TRACE("width(%d) x height(%d) x bpp(%d), size(%d)\n", 
		SCREEN_WIDTH, SCREEN_HEIGHT, SCREEN_BPP, nBytes);
		
	int wait=100;

	for(int j=0; j<nBytes; j+=4)
		*((__u32*)(SCREEN_BASEADDR+j)) = 0;
	fbUpdate();


	int maxIndex= (1 << SCREEN_BPP) - 1;
	//test drawing pixels
	int index= 0, y= 0, x= 0;
	for (y= 0; index <= Min(maxIndex,15) && y < SCREEN_HEIGHT && x < SCREEN_WIDTH ; y+=1, x+=1) {
		gdiSetForeColor((__u8)index++);
		gdiSetPixel(winGetDrawWindow(), x, y, 0);
	}
	fbUpdate();
	mtJediSleep(wait); //too fast, let it wait

	//test line
	for (index= 0; index <= maxIndex && y < SCREEN_HEIGHT; y+=1) {
		for(int x=0; x < SCREEN_WIDTH; x+=(SCREEN_WIDTH/4)) {
			gdiSetForeColor((__u8)index++);
			gdiLine(winGetDrawWindow(), x, y, x+(SCREEN_WIDTH/4), y, 0);
		}
	}
	fbUpdate();
	mtJediSleep(wait); //too fast, let it wait


	//test fill rectangle
	index=0;
	for (y+=4; index <= maxIndex && y < SCREEN_HEIGHT; y+=4) {
		for(int x=0; x < SCREEN_WIDTH; x+=(SCREEN_WIDTH)/16) {
			gdiSetForeColor(index++);
			TRect rect={{x,y},{(SCREEN_WIDTH)/16,4}};
			gdiFillRect(winGetDrawWindow(), &rect, 0, 0);
		}
	}
	fbUpdate();
	mtJediSleep(wait); //too fast, let it wait

	//test outline rectangle
	index=0;
	for(y+=4; index <= maxIndex && y < SCREEN_HEIGHT; y+=4) {
		for(int x=0; x < SCREEN_WIDTH; x+=(SCREEN_WIDTH)/16) {
			gdiSetForeColor(index++);
			TRect rect={{x,y},{(SCREEN_WIDTH)/16,4}};
			gdiOutlineRect(winGetDrawWindow(), &rect, 0, 0);
		}
	}
	fbUpdate();
	mtJediSleep(wait); //too fast, let it wait

	//test Round rect with clipping
	TRect clip={{0,0},{SCREEN_WIDTH/2, SCREEN_HEIGHT/2}};
	winSetClip(&clip);
	index= 0;
	TRect rct={{SCREEN_WIDTH/4, SCREEN_HEIGHT/4},{SCREEN_WIDTH/2, SCREEN_HEIGHT/2}};
	for(; index <= Min(maxIndex, 15); index++) {
		gdiSetForeColor(index);
		gdiFillRect(winGetDrawWindow(), &rct, index&7, 0);
		rctInset(&rct, 2);
		if (rct.Left() > rct.Right() ||
			rct.Top() > rct.Bottom()) 
			break;
	}
	fbUpdate();
	mtJediSleep(wait); //too fast, let it wait
	
	//test bitblt
	winResetClip();
	TRect rect={{0,0},{SCREEN_WIDTH/2, SCREEN_HEIGHT/2}};
	gdiBitBlt(winGetDrawWindow(), SCREEN_WIDTH/2, SCREEN_HEIGHT/2, 0, &rect, 0);
	fbUpdate();
	mtJediSleep(wait); //too fast, let it wait
	
	//test transparent blt
	_err_t err;
	TBmp *pBmp= bmpCreate(SCREEN_WIDTH/2, SCREEN_HEIGHT/2, SCREEN_BPP, bmpGetColorTable(g_pBmpScrn), &err);
	pBmp->transparentIndex= 0;
	pBmp->flags.hasTransparency=1;
	TWin *pWin= winCreateOffscreen(pBmp, 0);
	gdiSetForeColor(maxIndex/2);
	rect.Left()= 0; rect.Top()=0; rect.Width()=SCREEN_WIDTH/2, rect.Height()= SCREEN_HEIGHT/2;
	gdiFillRect(pWin, &rect, 0, 0);
	rctInset(&rect, SCREEN_WIDTH/16);
	gdiSetForeColor(0);
	gdiFillRect(pWin, &rect, 0, 0);
	rect.Left()= 0; rect.Top()= 0; rect.Width()=SCREEN_WIDTH/2, rect.Height()= SCREEN_HEIGHT/2;
	gdiBitBlt(winGetDrawWindow(), SCREEN_WIDTH*1/4, SCREEN_HEIGHT*1/4, pWin, &rect, 0);
	fbUpdate();
	winDestroy(pWin);
	bmpDestroy(pBmp);
	mtJediSleep(wait); //too fast, let it wait

	//test char drawing	
	fntSetFont(FONT_STD);
	const char *str= "Hello! Jedi.";
	gdiDrawChars(winGetDrawWindow(), str, strlen(str), 0, SCREEN_HEIGHT/2, 0);
	gdiSetUnderlineMode(DSUNDERLINE_GRAY);
	gdiDrawChars(winGetDrawWindow(), str, strlen(str), 8, SCREEN_HEIGHT/2+16, 0);
	fbUpdate();
	mtJediSleep(wait); //too fast, let it wait
	
	winErase(winGetDrawWindow(), 0);
	
	//test std fonts
	gdiSetForeColor(maxIndex);
	gdiSetTextColor(maxIndex);
	gdiSetBackColor(0);
	gdiSetUnderlineMode(DSUNDERLINE_NONE);
	x= 0; y=0;
	unsigned char i;
	int height= fntCharHeight();
	for (i= 0x20; i <= 0x7f; i++) {
		int width= fntCharWidth(i);
		if ((x + width) >= SCREEN_WIDTH) {
			x= 0;
			y+= height;
		}
		gdiDrawChars(winGetDrawWindow(), (char*)&i, 1, x, y, 0);
		x+= width;
	}		
	fbUpdate();
	mtJediSleep(wait); //too fast, let it wait

	//test bold fonts	
	x= 0; y+= height+4;
	fntSetFont(FONT_BOLD);
	height= fntCharHeight();
	for (i= 0x20; i <= 0x7f; i++) {
		int width= fntCharWidth(i);
		if ((x + width) >= SCREEN_WIDTH) {
			x= 0;
			y+= height;
		}
		gdiDrawChars(winGetDrawWindow(), (char*)&i, 1, x, y, 0);
		x+= width;
	}		
	fbUpdate();
	mtJediSleep(wait); //too fast, let it wait

	//test large fonts	
	x= 0; y+= height+4;
	fntSetFont(FONT_LARGE);
	height= fntCharHeight();
	for (i= 0x20; i <= 0x7f; i++) {
		int width= fntCharWidth(i);
		if ((x + width) >= SCREEN_WIDTH) {
			x= 0;
			y+= height;
		}
		gdiDrawChars(winGetDrawWindow(), (char*)&i, 1, x, y, 0);
		x+= width;
	}		
	fbUpdate();

	//change the last palette entry
//	j = (1<<SCREEN_BPP)-1;
//	FB_SET_RGB(s_palettes[j], 0, 0, 0x7f);
//	fbSetPalette(s_palettes, j, 1);

}

DEF_JEDITEST(TestGUI)
