/*	evttest.cxx

{{IS_NOTE

	Authors:	Tom M. Yeh
	Contributors:
	Create Date:	8/7/0 09:28PM
	$Header: /cvsroot/jedi/test/evt1.cxx,v 1.6 2000/09/05 06:38:33 tomyeh Exp $
	Purpose:	Testing codes for event
	Description:
	
}}IS_NOTE

Copyright (C) 2000 Infoshock Corporation. All Rights Reserved.

{{IS_RIGHT
}}IS_RIGHT
*/
#include <jedi/kernel.h>
#include <jedi/debug.h>
#include <jedi/event.h>
#include <jedi/time.h>

void TestTime()
{
	unsigned s = GetCurrentSeconds();
	TDateTime dt;
	SecondsToDateTime(s, &dt);
	TRACE("Now: %d/%d/%d, %d:%d:%d\n", dt.year, dt.month, dt.day, dt.hour, dt.minute, dt.second);
	TDate d;
	d.year	= 2000 - 1904;
	d.month	= 8;
	d.day	= 16;
	s = DateToDays(d);
	if(s != 35292)
		TRACE("Error: 2000/8/16 is not %d\n", s);
	else
		TRACE("DateToDays ok\n");
}

void TestEvent(void)
{
	TestTime();

	TEvent event;
	do{
		evtGetEvent(&event);
		TRACE("event: %d, %c, %d, (%d, %d), x%x, x%x, x%x, x%x\n", event.eType,
				event.penDown ? 'y': 'n', event.tapCount, event.screenX, event.screenY,
				*((unsigned*)event.data.generic.datum), *((unsigned*)(event.data.generic.datum+2)),
				*((unsigned*)(event.data.generic.datum+4)), *((unsigned*)(event.data.generic.datum+6)));
	}while(event.eType  != EVT_APPSTOP);
}

DEF_JEDITEST(TestEvent)
