/*	unixtime.cxx

{{IS_NOTE

	Authors:	Tom M. Yeh
	Contributors:
	Create Date:	9/26/0 09:16PM
	$Header: /cvsroot/jedi/sys/unixtime.cxx,v 1.2 2000/10/12 09:15:03 tomyeh Exp $
	Purpose:	Time functions based on Unix API
	Description:
	
}}IS_NOTE

Copyright (C) 2000 Infoshock Corporation. All Rights Reserved.

{{IS_RIGHT
}}IS_RIGHT
*/
#include <jedi/kernel.h>
#include <jedi/debug.h>
#include <jedi/mem.h>
#include <jedi/time.h>

#ifdef OS_USE_UNIX_TIME_API

#include <time.h>
#include <sys/time.h>

#define n1DayInSec		86400
#define nYear1			1904

///////////////////////////////////////////////////////
static __s32 _STDCALL ToGmSeconds(int year, int month, int day)
{
	struct tm tm;
	memset(&tm, 0, sizeof(tm));
	tm.tm_year	= year;
	tm.tm_mon	= month;
	tm.tm_mday	= day;
	return mktime(&tm);
}

static __s32 s_second1 = ToGmSeconds(nYear1, 1, 1);

EXTERN_C __u32 _JAPI ToSeconds(int year, int month, int day)
{
	return ToGmSeconds(year, month, day) - s_second1;
}

static struct tm* _STDCALL SecondsToTm(unsigned secs)
{
	time_t t = secs;
	t += s_second1;
	return localtime(&t);
}

///////////////////////////////////////////////////////
EXTERN_C void _AAPI SecondsToDate(unsigned secs, TDate* date)
{
	struct tm *p = SecondsToTm(secs);
	date->year	= p->tm_year - nYear1;
	date->month	= p->tm_mon;
	date->day	= p->tm_mday;
}

EXTERN_C void _AAPI DaysToDate(unsigned days, TDate* date)
{
	SecondsToDate(days*n1DayInSec, date); //to be enhanced: overflow is possible
}

EXTERN_C unsigned _AAPI DateToDays(TDate date)
{
	return ToSeconds(date.year+nYear1, date.month, date.day) / n1DayInSec;
}

EXTERN_C unsigned _AAPI DateTimeToSeconds(TDateTime* dt)
{
	struct tm tm;
	memset(&tm, 0, sizeof(tm));
	tm.tm_year	= dt->year;
	tm.tm_mon	= dt->month;
	tm.tm_mday	= dt->day;
	tm.tm_wday	= dt->weekDay;
	tm.tm_hour	= dt->hour;
	tm.tm_min	= dt->minute;
	tm.tm_sec	= dt->second;
	return mktime(&tm) - s_second1;
}

EXTERN_C void _AAPI SecondsToDateTime(unsigned secs, TDateTime* dt)
{
	struct tm *p = SecondsToTm(secs);
	dt->year	= p->tm_year - nYear1;
	dt->month	= p->tm_mon;
	dt->day		= p->tm_mday;
	dt->weekDay	= p->tm_wday;
	dt->hour	= p->tm_hour;
	dt->minute	= p->tm_min;
	dt->second	= p->tm_sec;
}

EXTERN_C int _AAPI DayOfWeek(int month, int day, int year)
{
	struct tm *p = SecondsToTm(ToSeconds(year, month, day));
	return p->tm_wday;
}

EXTERN_C unsigned _AAPI GetCurrentSeconds(void)
{
	return time(0) - s_second1;
}

EXTERN_C void _AAPI SetCurrentSeconds(unsigned secs)
{
	struct timeval tv;
	struct timezone tz;
	gettimeofday(&tv, &tz);
	tv.tv_sec = ((time_t)secs) + s_second1;
	settimeofday(&tv, &tz);
}

#endif //OS_USE_UNIX_TIME_API
