/*	trace.cxx

{{IS_NOTE

	Authors:	Tom M. Yeh
	Contributors:
	Create Date:	6/15/0 03:59PM
	$Header: /cvsroot/jedi/sys/trace.cxx,v 1.1 2000/09/28 03:16:06 tomyeh Exp $
	Purpose:	utlTrace
	Description:
	
}}IS_NOTE

Copyright (C) 2000 Infoshock Corporation. All Rights Reserved.

{{IS_RIGHT
}}IS_RIGHT
*/
#ifndef NDEBUG

#include <jedi/kernel.h>
#include <jedi/debug.h>

#include <stdio.h>

void utlTrace(const char* fmt, ...)
{
	va_list valist;
	va_start(valist, fmt);
	utlTrace(fmt, valist);
}

#if defined(__rtems__)
#include <bspIo.h>
#endif

void utlTrace(const char* fmt, va_list valist)
{
#ifdef __tvm__
	tvmTrace(0, fmt, valist);

#else //__tvm__
	char buf[1024];
	vsprintf(buf, fmt, valist);

 #ifdef __WinCE__
	OutputDebugString(_A2T(buf));
 #elif defined(__rtems__)
	puts(buf);  // should be able to use printk
 #else
 #error not yet
 #endif
#endif //__TVM__
}

#ifndef CAN_CPP_VALIST
static const char* s_flnm;
static int s_lnno;
void utlTraceInfo(const char* flnm, int lnno)
{
	s_flnm = flnm;
	s_lnno = lnno;
}

void utlTraceCond(int cond, char* fmt, ...)
{
	if(cond){
		utlTrace("%s, %d: ", s_flnm, s_lnno);

		va_list valist;
		va_start(valist, fmt);
		utlTrace(fmt, valist);
	}
}

void utlTraceLevel(int level, char* fmt, ...)
{
	if(level >= (TRACELEVEL)){
		utlTrace("%s, %d: ", s_flnm, s_lnno);

		va_list valist;
		va_start(valist, fmt);
		utlTrace(fmt, valist);
	}
}
#endif //CAN_CPP_VALIST
#endif //-------------- No function at all if NDEBUG
