/*	time.cxx

{{IS_NOTE

	Authors:	Tom M. Yeh
	Contributors:
	Create Date:	8/15/0 09:31AM
	$Header: /cvsroot/jedi/sys/time.cxx,v 1.1 2000/08/16 06:53:43 tomyeh Exp $
	Purpose:	Platform independent functions
	Description:
	
}}IS_NOTE

Copyright (C) 2000 Infoshock Corporation. All Rights Reserved.

{{IS_RIGHT
}}IS_RIGHT
*/
#include <jedi/kernel.h>
#include <jedi/debug.h>
#include <jedi/time.h>

EXTERN_C void _AAPI AddDate(TDate* date, int diff)
{
	DaysToDate(((int)DateToDays(*date)) + diff, date);
}

EXTERN_C void _AAPI AddDateTime(TDateTime* date, int diff)
{
	SecondsToDateTime(((int)DateTimeToSeconds(date)) + diff, date);
}

EXTERN_C int _AAPI DayOfMonth(int month, int day, int year)
{
	if(day<=7) //first week?
		return DayOfWeek(month, day, year);

	int v = DayOfWeek(month, 1, year);
	return day + v -1;
}

EXTERN_C int _AAPI DaysInMonth(int month, int year)
{
	static const __u8 mons[] =
		{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
		//1   2   3   4   5   6   7   8   9   10  11  12
	return month!=2 ? mons[((unsigned)month) > 12 ? 12: month]:
		!(year & 3) && ((year % 100) || !(year % 400)) ? 29: 28;
}

//EXTERN_C void _AAPI dtToAscii(__u8 mon, __u8 day, __u16 year, int fmt, char* pStr);
//EXTERN_C void _AAPI dtToDOWDMFormat(__u8 mon, __u8 day, __u16 year, int fmt, char* pStr);
//EXTERN_C void _AAPI TimeToAscii (UInt8 hours, UInt8 minutes, int fmt, char* pString);
