/*	start.cxx

{{IS_NOTE

	Authors:	Tom M. Yeh
	Contributors:
	Create Date:	6/8/0 10:15PM
	$Header: /cvsroot/jedi/sys/start.cxx,v 1.4 2000/10/03 06:16:13 henrichen Exp $
	Purpose:	Initialization
	Description:
	
}}IS_NOTE

Copyright (C) 2000 Infoshock Corporation. All Rights Reserved.

{{IS_RIGHT
}}IS_RIGHT
*/
#include <jedi/kernel.h>
#include <jedi/debug.h>
#include <jedi/mem.h>
#include <jedi/fb.h>
#include <jedi/thread.h>
#include <jedi/launch.h>
#include <lib/strutl.h>

//////////////////////////////////////////////////////////
//system level
EXTERN_C void _JAPI fntSysInit(void);
EXTERN_C void _JAPI fntSysCleanup(void);
EXTERN_C void _JAPI gdiSysInit(void);
EXTERN_C void _JAPI gdiSysCleanup();
EXTERN_C void _JAPI evtSysCleanup(void);
EXTERN_C void _JAPI winSysInit(void);
EXTERN_C void _JAPI dmSysInit(void);
EXTERN_C void _JAPI dmSysCleanup(void);

//////////////////////////////////////////////////////////
unsigned g_thdLocalIndex;

EXTERN_C void _JAPI JediStart(const char* prcName)
{
	g_thdLocalIndex = mtAllocTls();

	//Configure h/w
	//If the configuration fails, the routine shall ASSERT
	fntSysInit();
	gdiSysInit();
	winSysInit();
//	dmSysInit();

	TLaunchInfo lf;
	lf.cmd		= LCMD_NORMALLAUNCH;
	lf.flags	= LFLAG_NEWTHREAD|LFLAG_NEWSTACK;
	if(prcName) strncpy(lf.prcName, prcName, MAX_DB_NAME_LEN-PRC_EXT_SIZE-2);
	else lf.prcName[0] = 0;

	AnakinLock(); //Launch expects the lock though there is no other thread now
	if(Launch(&lf))
		TRACE("Failed to launch the first application\n");
	AnakinUnlock();
}

EXTERN_C void _JAPI JediStop(void)
{
//	dmSysCleanup();
	gdiSysCleanup();
	fntSysCleanup();
	evtSysCleanup();

	mtFreeTls(g_thdLocalIndex);
}
