/*	lockjmp.cxx

{{IS_NOTE

	Authors:	Joel Sherrill <joel@OARcorp.com>
	Contributors:
	Create Date:	15 December 2000
	$Header$
	Purpose:	portable AnakinLockAndJump for RTEMS
	Description:
	
}}IS_NOTE

Copyright (C) 2000 Infoshock Corporation. All Rights Reserved.

{{IS_RIGHT
}}IS_RIGHT
*/
#include <jedi/kernel.h>
#include <jedi/debug.h>
#include <jedi/thread.h>

// I don't really know where to put this -- joel.
__rtems_tls_t __RTEMS_TLS = { 0, NULL };

EXTERN_C void AnakinLockAndJump(void (*func)(void))
{
// It should be possible to do this better by switching on the CPU
// but it is better to be portable at this point.
  AnakinLock();
  (*func)();
  AnakinUnlock();
}

// simple wrappers until we use mem.h
#undef realloc
extern "C" { void *realloc(void *,size_t); }

void *rtems_realloc_wrapper( void *p, size_t size )
{

  return realloc(p, size);
}

