/*	lockjmp.cxx

{{IS_NOTE

	Authors:	Tom M. Yeh
	Contributors:
	Create Date:	9/26/0 07:04PM
	$Header: /cvsroot/jedi/sys/msc/lockjmp.cxx,v 1.1.1.1 2000/09/27 04:02:49 tomyeh Exp $
	Purpose:	AnakinLockAndJump for MSC
	Description:
	
}}IS_NOTE

Copyright (C) 2000 Infoshock Corporation. All Rights Reserved.

{{IS_RIGHT
}}IS_RIGHT
*/
#include <jedi/kernel.h>
#include <jedi/debug.h>
#include <jedi/thread.h>

EXTERN_C _NAKED void AnakinLockAndJump()
{
	static void (*s_retAddr)(); //cannot on stack

	__asm {
#ifdef __i486__
		push	eax				//save the destination
		call	AnakinLock
		pop		eax				//restore
		pop		s_retAddr		//save the addr to return
		push	offset l_unlock	//let the destination return to l_unlock
		jmp		eax				//call the destination
	l_unlock:
		push	eax				//save the returned value
		call	AnakinUnlock
		pop		eax
		jmp		s_retAddr		//return
#else //__i486__
 #error AnakinLockAndJump must be adapted to new processors
#endif //__i486__
	}
}
