/*	launch.cxx

{{IS_NOTE

	Authors:	Tom M. Yeh
	Contributors:
	Create Date:	9/4/0 10:54AM
	$Header: /cvsroot/jedi/sys/launch.cxx,v 1.11 2000/10/03 10:24:52 tomyeh Exp $
	Purpose:	Launch application
	Description:
	
}}IS_NOTE

Copyright (C) 2000 Infoshock Corporation. All Rights Reserved.

{{IS_RIGHT
}}IS_RIGHT
*/
#include <jedi/kernel.h>
#include <jedi/debug.h>
#include <jedi/errmgr.h>
#include <jedi/mem.h>
#include <jedi/event.h>
#include <jedi/launch.h>
#include <lib/strutl.h>
#include <lib/llink.h>

////////////////////////////////////////////////////////
bool g_bSysStopping = false;
struct TAppLocal* g_listApp = 0;

#ifndef NDEBUG
void (*g_pJediTest)(void) = 0;
	//It specified a function to test. If set, DoLauch won't be called.
#endif

////////////////////////////////////////////////////////
EXTERN_C void _AAPI AppThdFunc(void*);

//app level init/cleanup
EXTERN_C void _JAPI frmAppCleanup(TAppLocal* app);
EXTERN_C void _JAPI mnuAppCleanup(TAppLocal* app);
EXTERN_C void _JAPI bmpAppCleanup(TAppLocal* app);
EXTERN_C void _JAPI dmAppCleanup(TAppLocal* app);
EXTERN_C void _JAPI winAppCleanup(__u32 owner);

////////////////////////////////////////////////////////
_err_t _JAPI Launch(TLaunchInfo* lf)
{
	if(g_bSysStopping)
		return ERRS_SYSTEMSTOPPING;

	if(lf->cmd==LCMD_NORMALLAUNCH){
		if(lf->prcName[0])
			lf->prcName[MAX_DB_NAME_LEN - PRC_EXT_SIZE -2] = 0;//in case: overrun
		else
			memcpy(lf->prcName, APP_JEDIHOME, CountOf(APP_JEDIHOME));

		if(lf->flags & (LFLAG_NEWTHREAD|LFLAG_NEWSTACK)){
			lf->out.nThdId = mtCreateThread(AppThdFunc, lf->prcName);
				//Note: lf->prcName is stored in stack but it is OK
				//because mtCreateThread will copy it to heap when
				//it detects AppThdFunc
			if(!lf->out.nThdId)
				return ERRM_NOTENOUGHSPACE;

		}else{
			TAppLocal* app = GetAppLocal();
			ASSERT(app);
			lf->out.nThdId = app->pThdLocal->nId; //thread Id won't change
			strcpy(app->prcNext, lf->prcName);
			evtPushEventEx(EVT_APPSTOP);
		}
	}else{
		ASSERT(0); //not yet;
	}

	return 0;
}

////////////////////////////////////////////////////////
static _err_t _JAPI DoLaunch(TLaunchInfo* lf)
{
	TRACE("Launch %s...\n", lf->prcName);

	strext(lf->prcName, DLL_EXT);

	volatile _dll_t hDll = OsDllOpen(lf->prcName);
	if(!hDll){
		hDll = OsDllOpen(APP_JEDIVM_DLL);
		if(!hDll){
			TRACE("Unable to load %s\n", dbpath(lf->prcName));
			return ERRS_ENTRYNOTFOUND;
		}
	}

	volatile int iRet = 0;
	_dll_f pfMain = OsDllGet(hDll, "JediMain");
	_dll_f pfAttach = OsDllGet(hDll, "JediAttach");
	if(pfMain && pfAttach){
		strext(lf->prcName, PRC_EXT); //restore

		AnakinUnlock(); //release the lock since going to user space
		exTRY{
			if(((_jediattach_f)pfAttach)(&gJdk_api, &gJdk_apiEx))
				lf->out.result = ((_jedimain_f)pfMain)(lf);
			else
				iRet = ERRS_ENTRYNOTFOUND;
		}exCATCH(errCode){
			lf->out.result = -1;
			TRACE("An uncatched exception is found, %d\n", errCode);
		}exEND
		AnakinLock(); //grant back
	}else{
		iRet = ERRS_ENTRYNOTFOUND;
		TRACE("Invalid dll, %s\n", lf->prcName);
	}

	AppLaunchCleanup(0, GetThdLocal()->nId);

	//Tom:
	//Due a Win/CE problem: we cannot free the loaded dll immediately
	//after a thread is killed by mtOsKillThread (called by
	//AppLaunchCleanup if needed). Otherwise, it hangs.
	//AnakinUnlock and yield is a must, but I don't know why.
	AnakinUnlock();
	mtAnakinSleep(4); //0 seems enough but we play safe here
	exTRY{
		//Note: FreeLibrary will cause DllMain of the dll being called
		//we have to protect it from exception due to destructors.
		OsDllClose(hDll);
	}exCATCH(errCode){
		TRACE("An uncatched eception is found during FreeLibrary, %d\n", errCode);
	}exEND
	AnakinLock();
	return iRet;
}

EXTERN_C void _AAPI AppThdFunc(void*)
{
	AnakinLock();//it is called w/o lock, so...
	TAppLocal* app = GetAppLocal();

	do{
		TLaunchInfo lf;
		strcpy(lf.prcName, app->prcNext);
		app->prcNext[0] = 0; //change the next app as default
		strext(lf.prcName, PRC_EXT);
		lf.flags		= LFLAG_NORMALLAUNCH;
		lf.cmd			= LCMD_NORMALLAUNCH;
		lf.cmdPBP		= 0;

#ifndef NDEBUG
		if(g_pJediTest)
			g_pJediTest();
		else
#endif
		DoLaunch(&lf);

		AppLaunchCleanup(0, 0);
	}while(
#ifndef NDEBUG
		!g_pJediTest &&
#endif
		!g_bSysStopping && app->prcNext[0]);

	//No need to call AppCleanup here because ThreadFunc will do it
	AnakinUnlock();
}

////////////////////////////////////////////////////////
EXTERN_C void _AAPI mtExitProcess(void)
{
	AppCleanup(0, true);
}

////////////////////////////////////////////////////////
EXTERN_C void _JAPI AppLaunchCleanup(TAppLocal* app, __u32 nIdOwner)
{
	if(!app) app = GetAppLocal();

	//clean up thread related data
	for(TThdLocal *thd = app->pThdLocal; thd;){
		TThdLocal *t = thd;
		thd = thd->next;
		if(!nIdOwner || nIdOwner==t->nIdOwner)
			ThdCleanup(t, t!=app->pThdLocal);
				//don't detach the main thread; we recylce it
	}

	//note the order is important
	frmAppCleanup(app);
	mnuAppCleanup(app);
	winAppCleanup(app->pThdLocal->nId);
	bmpAppCleanup(app);
//	dmAppCleanup(app);
 
	mmFreeByOwner(0, app->pThdLocal->nId);
}

EXTERN_C void _JAPI AppCleanup(TAppLocal* app, bool bExitThread)
{
	TAppLocal* thisApp = GetAppLocal();
	if(!app) app = thisApp;

	//cleanup all threads but the main
	AppLaunchCleanup(app, 0);

	//cleanup the main thread
	ASSERT(app->pThdLocal);
	ASSERT(!app->pThdLocal->next); //AppLaunchCleanup must be called before
	ThdCleanup(app->pThdLocal);

	sllUnlink((void**)&g_listApp, app, OffsetOf(TAppLocal, next));
	_FREE(app);

	if(!g_listApp) //an app is destroyed
		mtOsNotifyNoApp();

	if(bExitThread && app==thisApp){
		AnakinUnlock(); //release the lock
		mtOsExitThread();
	}
}
