/*	tvmfnt.cxx

{{IS_NOTE

	Authors:	Henri Chen
	Contributors:
	Create Date:	2000/9/26 04:04PM
	$Header: /cvsroot/jedi/tvm/tvmfnt.cxx,v 1.4 2000/10/05 07:22:15 henrichen Exp $
	Purpose:	
	Description:	Implementation dependent part of fntXXX() for TVM

}}IS_NOTE

Copyright (C) 2000 Infoshock Corporation. All Rights Reserved.

{{IS_RIGHT
}}IS_RIGHT
*/
#include <jedi/kernel.h>
#include <jedi/debug.h>
#include <jedi/win.h>
#include <jedi/gdi.h>
#include <jedi/fnt.h>

//?? 20000714, Henri Chen: unmark following __USE_EMBEDDED_FONT__ will embedded font into exe.
#define	__USE_EMBEDDED_FONT__

///////////////////////////////////////////////////////////
// data
#ifdef	__USE_EMBEDDED_FONT__
#include "helvR10.efh"
#include "helvB10.efh"
#include "rom8.efh"
#endif	//__USE_EMBEDDED_FONT__

//?? 20000914, Henri Chen: now support only one font.
EXTERN_C void _JAPI fntOsSysInit(void)
{
	//Note the other fields of TFont are inited by fntInit
	g_pSysFonts[FONT_STD]	= &fnt_helvR10;
	g_pSysFonts[FONT_BOLD]	= &fnt_helvB10;
	g_pSysFonts[FONT_LARGE]	= &fnt_rom8;
}

EXTERN_C void _JAPI fntOsSysCleanup(void)
{
}

//////////////////////////////////////////////////////////////////
EXTERN_C int _JAPI fntGetCharWidth(__s16 fontId, const char ch)
{
	TFont *p= fntGetTFont(fontId);
	
	//not a normal one, return the missing character width
	int x= (ch > p->lastChar || ch < p->firstChar) ? p->lastChar+1 : ch;
	return (((TFontCharInfo*)((__u8*)p+p->ofInfo))+(x-p->firstChar))->width;
}

inline int fntGetCharsWidth(__s16 fontId, const char* str, int len)
{
	ASSERT(str);
	int w=0;
	while(len-- && *str)
		w+= fntGetCharWidth(fontId, *str++);
	return w;
}

EXTERN_C void _JAPI fntGetExtent(__s16 fontId, const char *str, TRect *pRect)
{
	TFont *pFont= fntGetTFont(fontId);
	ASSERT(pFont);
	if (!str || strlen(str) == 0) {
		memset(pRect, 0, sizeof(TRect));
		return;
	}

	pRect->Width()= (__s16) fntGetCharsWidth(fontId, str, strlen(str));
	pRect->Height()= (__s16) pFont->height;
}
