/*	mem.cxx

{{IS_NOTE

	Authors:	Tom M. Yeh
	Contributors:
	Create Date:	7/12/0 05:32PM
	$Header: /cvsroot/jedi/mem/mem.cxx,v 1.5 2000/09/26 10:09:26 tomyeh Exp $
	Purpose:	memory allocators
	Description:
	
}}IS_NOTE

Copyright (C) 2000 Infoshock Corporation. All Rights Reserved.

{{IS_RIGHT
}}IS_RIGHT
*/
#include <jedi/kernel.h>
#include <jedi/debug.h>
#include <jedi/mem.h>

#undef malloc
#undef free

#if defined(__WinCE__) /////////////////////////////////////
#include <malloc.h>

inline size_t _JAPI __msize(void* p)
{
	return _msize(p);
}

#elif defined(__tvm__) /////////////////////////////////////

inline void *malloc(size_t sz)
{
	return tvmAlloc(sz);
}

inline void* calloc(size_t nm, size_t sz)
{
	void* p = malloc(sz *= nm);
	if(p) memset(p, 0, sz);
	return p;
}

inline void* realloc(void* p, size_t sz)
{
	return tvmRealloc(p, sz);
}

inline void free(void* p)
{
	tvmFree(p);
}

inline size_t _JAPI __msize(void* p)
{
	return tvmMSize(p);
}
#elif defined(__rtems__)
#warning "FIX ME in mem.cxx"
inline void *malloc(size_t sz)
{
        return 0;
}

inline void* calloc(size_t nm, size_t sz)
{
        void* p = malloc(sz *= nm);
        if(p) memset(p, 0, sz);
        return p;
}

inline void* realloc(void* p, size_t sz)
{
        return 0;
}

inline void free(void* p)
{
}

inline size_t _JAPI __msize(void* p)
{
        return 0;
}
#else /////////////////////////////////////
#error not yet: implement the following based on mmAlloc...
#endif

//////////////////////////////////////////////////////////
//Take care of small blocks
EXTERN_C void* _JAPI _malloc(size_t sz)
{
	return malloc(sz);
}

EXTERN_C void* _JAPI _calloc(size_t nm, size_t sz)
{
	return calloc(nm, sz);
}

EXTERN_C void* _JAPI _realloc(void* p, size_t sz)
{
	return realloc(p, sz);
}

EXTERN_C void  _JAPI _free(void* p)
{
	free(p);
}

EXTERN_C size_t _JAPI _memsize(void* p)
{
	return __msize(p);
}
