/*	strext.cxx

{{IS_NOTE

	Authors:	Tom M. Yeh
	Contributors:
	Create Date:	8/9/0 10:39AM
	$Header: /cvsroot/jedi/lib/strext.cxx,v 1.3 2000/08/30 07:49:49 tomyeh Exp $
	Purpose:	Change the extension of a string
	Description:
	
}}IS_NOTE

Copyright (C) 2000 Infoshock Corporation. All Rights Reserved.

{{IS_RIGHT
}}IS_RIGHT
*/
#include <jedi/kernel.h>
#include <jedi/debug.h>
#include <lib/strutl.h>

char* _JAPI strext(char* str, const char* ext)
{
	if(!str)
		return 0;

	char* end = str + strlen(str);
	char* p = end;
	for(;;)
		if(--p<str || *p=='/'){
			p = end;
			break;
		}else if(*p=='.')
			break;

	if(ext){
		*p++ = '.';

		if(ext[0]=='.') ++ext;
		strcpy(p, ext);
	}else
		*p = 0; //no extension at all (not even '.')

	return str;
}
