/*	lcllink.cxx

{{IS_NOTE

	Authors:	Tom M. Yeh
	Contributors:
	Create Date:	8/30/0 07:12PM
	$Header: /cvsroot/jedi/lib/lcllink.cxx,v 1.4 2000/09/26 10:09:26 tomyeh Exp $
	Purpose:	TLclLink
	Description:
	
}}IS_NOTE

Copyright (C) 2000 Infoshock Corporation. All Rights Reserved.

{{IS_RIGHT
}}IS_RIGHT
*/
#include <jedi/kernel.h>
#include <jedi/debug.h>
#include <lib/lcllink.h>

inline TLclLinkNode** _tlGetListAddr(void* listLocal, int listOfs)
{
	ASSERT(listLocal);
	return (TLclLinkNode**)(((char*)listLocal) + listOfs);
}

EXTERN_C void _JAPI _tlLink(TLclLinkNode* obj, void* listLocal, int listOfs)
{
	TLclLinkNode **plistObj = _tlGetListAddr(listLocal, listOfs);
	obj->_ll_next	= *plistObj;
	*plistObj		= obj;
}

EXTERN_C void _JAPI _tlUnlink(TLclLinkNode* obj, void* listLocal, int listOfs)
{
	TLclLinkNode **plistObj = _tlGetListAddr(listLocal, listOfs);
	while(*plistObj){
		TLclLinkNode **pnext = &(*plistObj)->_ll_next;
		if(*plistObj == obj){
			*plistObj = *pnext;
			break;
		}
		plistObj = pnext;
	}
}

EXTERN_C void _JAPI _tlMoveToTop(TLclLinkNode *obj, void* listLocal, int listOfs)
{
	_tlUnlink(obj, listLocal, listOfs);
	_tlLink(obj, listLocal, listOfs);
}

EXTERN_C void _JAPI _tlApply(void (*pf)(void*, void*), void* listLocal, int listOfs)
{
	TLclLinkNode *listObj = *_tlGetListAddr(listLocal, listOfs);
	while(listObj){
		TLclLinkNode *q	= listObj;
		listObj = listObj->_ll_next; //advance first because p might be delete
		pf(((char*)q) + sizeof(TLclLinkNode), listObj);
	}
}

EXTERN_C void* _JAPI _tlFind(bool (*pf)(void*, int), int val, void* listLocal, int listOfs)
{
	TLclLinkNode *listObj = *_tlGetListAddr(listLocal, listOfs);
	for(; listObj; listObj = listObj->_ll_next){
		void* pT = ((char*)listObj) + sizeof(TLclLinkNode);
		if(pf(pT, val))
			return pT;
	}
	return 0;
}

#ifndef NDEBUG
EXTERN_C void _JAPI _tlDump(const char *msg, void* listLocal, int listOfs)
{
	TLclLinkNode *listObj = *_tlGetListAddr(listLocal, listOfs);
	if(listObj){
		utlTrace(">>>>%s: ", msg);
		for(; listObj; listObj = listObj->_ll_next)
			utlTrace(" %p", ((char*)listObj) + sizeof(TLclLinkNode));
		utlTrace("\n");
	}
}
#endif
