/*	elf_start.cxx

{{IS_NOTE

	Authors:	Tom M. Yeh
	Contributors:
	Create Date:	9/22/0 11:24AM
	$Header: /cvsroot/jedi/jdk/elf_start.cxx,v 1.2 2000/10/04 03:28:31 tomyeh Exp $
	Purpose:	The startup codes of libjdk for ELF format
	Description:
	
}}IS_NOTE

Copyright (C) 2000 Infoshock Corporation. All Rights Reserved.

{{IS_RIGHT
}}IS_RIGHT
*/
#include <jedi/kernel.h>
#include <jedi/debug.h>
#include <jedi/launch.h>

////////////////////////////////////////////////////////////////
EXTERN_C __u32 PilotMain(__u16 cmd, void* cmdPBP, __u16 launchFlags);

////////////////////////////////////////////////////////////////
EXTERN_C_BEGIN
const TAnakinApi* gJdk_pApi;
const TAnakinExApi* gJdk_pApiEx;
const char* gJdk_pPrcName;
EXTERN_C_END

////////////////////////////////////////////////////////////////
EXTERN_C _JDK_EXPORT int _CDECL JediMain(TLaunchInfo* lf)
{
	ASSERT(gJdk_pApi && gJdk_pApiEx);
	gJdk_pPrcName = lf->prcName;
	return (int)PilotMain(lf->cmd, lf->cmdPBP, lf->flags);
}

EXTERN_C _JDK_EXPORT BOOL _CDECL JediAttach(
	const TAnakinApi* api, const TAnakinExApi* apiEx)
{
	gJdk_pApi = api;
	gJdk_pApiEx = apiEx;
	return true;
}
