/*	ce_start.cxx

{{IS_NOTE

	Authors:	Tom M. Yeh
	Contributors:
	Create Date:	8/8/0 04:10PM
	$Header: /cvsroot/jedi/jdk/ce_start.cxx,v 1.5 2000/09/12 12:12:06 tomyeh Exp $
	Purpose:	The startup codes of libjdk for Windows CE
	Description:
	
}}IS_NOTE

Copyright (C) 2000 Infoshock Corporation. All Rights Reserved.

{{IS_RIGHT
}}IS_RIGHT
*/
#include <jedi/kernel.h>
#include <jedi/debug.h>

#define _JDK_EXPORT __declspec(dllexport)
#include <jedi/launch.h>

////////////////////////////////////////////////////////////////
EXTERN_C __u32 PilotMain(__u16 cmd, void* cmdPBP, __u16 launchFlags);

EXTERN_C BOOL WINAPI _DllMainCRTStartup(
	HANDLE hDllHandle, DWORD dwReason, LPVOID lpreserved);
	//The original startup codes

////////////////////////////////////////////////////////////////
EXTERN_C_BEGIN
const TAnakinApi* gJdk_pApi;
const TAnakinExApi* gJdk_pApiEx;
const char* gJdk_pPrcName;
EXTERN_C_END

HANDLE _g_hDllHandle;
LPVOID _g_lpreserved;

////////////////////////////////////////////////////////////////
EXTERN_C _JDK_EXPORT int _CDECL JediMain(TLaunchInfo* lf)
{
	gJdk_pPrcName = lf->prcName;
	return (int)PilotMain(lf->cmd, lf->cmdPBP, lf->flags);
}

EXTERN_C _JDK_EXPORT BOOL _CDECL JediAttach(
	const TAnakinApi* api, const TAnakinExApi* apiEx)
{
	gJdk_pApi = api;
	gJdk_pApiEx = apiEx;
	return _DllMainCRTStartup(_g_hDllHandle, DLL_PROCESS_ATTACH, _g_lpreserved);
}

////////////////////////////////////////////////////////////////

EXTERN_C BOOL WINAPI _JediMainCRTStartup(
	HANDLE hDllHandle, DWORD dwReason, LPVOID lpreserved)
{
	//Note: we separate it into two steps because _DllMainCRTStartup
	//will initialize C global variables which might call Anakin
	if(dwReason==DLL_PROCESS_ATTACH){
		_g_hDllHandle = hDllHandle;
		_g_lpreserved = lpreserved;
		return TRUE;
	}else
		return _DllMainCRTStartup(hDllHandle, dwReason, lpreserved);
}
