/*	iwfwnd.cxx

{{IS_NOTE

Authors:	Tom M. Yeh
Contributors:
Create Date:	7/28/0 09:44AM
$Header: /cvsroot/jedi/iwf/iwfwnd.cxx,v 1.3 2000/08/03 12:05:11 tomyeh Exp $
Purpose:	CWnd and CDlg
Description:

}}IS_NOTE

Copyright (C) 2000 Infoshock Corporation. All Rights Reserved.

{{IS_RIGHT
}}IS_RIGHT
*/
#include <jedi/kernel.h>
#include <jedi/debug.h>

///////////////////////////////////////////////////////
CWnd* CWnd::PreWndProc(HWND hWnd,UINT uMsg,WPARAM /*wParam*/,LPARAM lParam)
{
	CWnd* wnd = (CWnd*)GetWindowLong(hWnd, 0);

	if(uMsg==WM_CREATE){
		ASSERT(!wnd);
		wnd = (CWnd*)(((CREATESTRUCT*)lParam)->lpCreateParams);
		wnd->m_hWnd = hWnd;
		SetWindowLong(hWnd, 0, (LONG)wnd);
	}

	return wnd;
}

LRESULT CWnd::SendItemMessage(int nId, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	return (LRESULT)::SendMessage(GetItem(nId), uMsg, wParam, lParam);
}

///////////////////////////////////////////////////////
CFrame::CFrame()
{
	memset(&m_sai, 0, sizeof(m_sai));
	m_sai.cbSize = sizeof(SHACTIVATEINFO);
}

CFrame* CFrame::PreWndProc(HWND hWnd,UINT uMsg,WPARAM wParam,LPARAM lParam)
{
	CFrame* wnd = (CFrame*)CWnd::PreWndProc(hWnd, uMsg, wParam, lParam);

	switch(uMsg){
	case WM_SETTINGCHANGE:
		SHHandleWMSettingChange(hWnd, wParam, lParam, &wnd->m_sai);
		break;

	case WM_ACTIVATE:
		SHHandleWMActivate(hWnd, wParam, lParam, &wnd->m_sai, FALSE);
		break;

	case WM_DESTROY:
		PostQuitMessage(0);
		break;
	}

	return wnd;
}

void CFrame::MoveByClient(int wdClient, int hghClient)
{
	CRect rc;
	rc.left = rc.top = 0;
	rc.right = wdClient; rc.bottom = hghClient;
	AdjustWindowRectEx(&rc, GetWindowLong(m_hWnd, GWL_STYLE),
			false, GetWindowLong(m_hWnd, GWL_EXSTYLE));
	SetWindowPos(m_hWnd, 0, 0, 0, rc.Width(), rc.Height(), 
			SWP_NOMOVE|SWP_NOZORDER|SWP_NOACTIVATE);
}

///////////////////////////////////////////////////////
CDlg* CDlg::PreWndProc(HWND hWnd,UINT uMsg,WPARAM /*wParam*/,LPARAM lParam)
{
	CDlg* wnd = (CDlg*)GetWindowLong(hWnd, DWL_USER);

	if(uMsg==WM_INITDIALOG){
		ASSERT(!wnd);
		wnd = (CDlg*)lParam;
		wnd->m_hWnd = hWnd;
		SetWindowLong(hWnd, DWL_USER, (LONG)wnd);

		SHINITDLGINFO shidi;
		shidi.dwMask = SHIDIM_FLAGS;
		shidi.dwFlags = SHIDIF_DONEBUTTON | SHIDIF_SIZEDLGFULLSCREEN;
		shidi.hDlg = hWnd;
		SHInitDialog(&shidi);

		wnd->m_cmdBar.Create(wnd, IDM_DIALOG);
	}

	return wnd;
}
