/*	iwfchar.cxx

{{IS_NOTE

Authors:	Tom M. Yeh
Contributors:
Create Date:	7/25/0 02:19PM
$Header: /cvsroot/jedi/iwf/iwfchar.cxx,v 1.2 2000/08/01 08:07:59 tomyeh Exp $
Purpose:	Unicode utilities
Description:

}}IS_NOTE

Copyright (C) 2000 Infoshock Corporation. All Rights Reserved.

{{IS_RIGHT
}}IS_RIGHT
*/
#include <jedi/kernel.h>
#include <jedi/debug.h>

#ifdef _WIN32_WCE
LPSTR WINAPI lstrcpynA(LPSTR dst, LPCSTR src, int n)
{
	if(!dst || !src || n<=1){
		if(n==1 && dst) *dst = 0;
		return dst;
	}

	int len = strlen(src)+1;
	n = Min(len, n);
	memcpy(dst, src, n);
	dst[n-1] = 0;
	return dst;
}

LPWSTR WINAPI lstrcpynW(LPWSTR dst, LPCWSTR src, int n)
{
	if(!dst || !src || n<=1){
		if(n==1 && dst) *dst = 0;
		return dst;
	}

	int len = lstrlenW(src) + 1;
	n = Min(len, n);
	memcpy(dst, src, n * sizeof(wchar_t));
	dst[n-1] = 0;
	return dst;
}
#endif
