/*	thread.h

{{IS_NOTE

Authors:	Tom M. Yeh
Contributors:
Create Date:	7/11/0 09:12PM
$Header: /cvsroot/jedi/include__tvm__/os/thread.h,v 1.9 2000/09/27 04:05:00 tomyeh Exp $
Purpose:	thread of TVM
Description:

}}IS_NOTE

Copyright (C) 2000 Infoshock Corporation. All Rights Reserved.

{{IS_RIGHT
}}IS_RIGHT
*/
#ifndef _is_os_thread_H
#define _is_os_thread_H

////////////////////////////////////////////////////////
typedef pthread_t		_handle_t;
typedef pthread_mutex_t	_mutex_t;
typedef pthread_cond_t	_cond_t;

#define OSTHD_RET_T		void
#define OSTHD_API		_CDECL
#define OSTHD_API_O		_CDECL_O
#define OSTHD_API_I		_CDECL_I
typedef OSTHD_RET_T OSTHD_API_O(OSTHD_API_I*_osthread_f)(void*);

////////////////////////////////////////////////////////
EXTERN_C_BEGIN

inline _handle_t _JAPI mtOsCreateThread(
	_osthread_f entry, void* data, unsigned stackSize, __u32* pThdId)
	{return tvmCreateThread(entry, data, stackSize, pThdId);}

inline void _JAPI mtOsDetachThread(_handle_t hThd) {tvmDetachThread(hThd);}

inline __u32 _JAPI mtOsGetCurrentThreadId(void) {return tvmGetCurrentThreadId();}

inline void _JAPI mtOsExitThread(void) {tvmExitThread();}
inline void _JAPI mtOsKillThread(_handle_t hThd) {tvmKillThread(hThd);}

inline void _JAPI mtAnakinSleep(unsigned ticks) {tvmSleep(ticks);}
inline void _JAPI mtAnakinYield(void) {tvmYield();}

inline bool _JAPI mtOsWaitThread(_handle_t hThd, unsigned toTicks) {return tvmWaitThread(hThd, toTicks);}

inline bool _JAPI mtOsSetPriority(_handle_t hThd, int priority) {return tvmSetThreadPriority(hThd, priority);}
inline int _JAPI mtOsGetPriority(_handle_t hThd) {return tvmGetThreadPriority(hThd);}

inline void mtInitMutex(_mutex_t* mutex) {tvmInitMutex(mutex);}
inline void mtDestroyMutex(_mutex_t* mutex) {tvmDestroyMutex(mutex);}
inline void mtLockMutex(_mutex_t* mutex) {tvmLockMutex(mutex);}
inline void mtUnlockMutex(_mutex_t* mutex) {tvmUnlockMutex(mutex);}

inline void _JAPI mtInitCond(_cond_t* cond, _mutex_t* mutex, bool bBroadcast)
{
	ASSERT(!bBroadcast);
	tvmInitCond(cond, mutex);
}

inline void _JAPI mtDestroyCond(_cond_t* cond) {tvmDestroyCond(cond);}
inline void _JAPI mtSetCond(_cond_t* cond) {tvmSetCond(cond);}
inline bool _AAPI mtWaitCond(_cond_t* cond, unsigned toTicks) {return tvmWaitCond(cond, toTicks);}

inline unsigned _JAPI mtAllocTls(void) {return tvmAllocTls();}
inline BOOL _JAPI mtFreeTls(unsigned index) {return tvmFreeTls(index);}
inline void* _JAPI mtGetTls(unsigned index) {return tvmGetTls(index);}
inline BOOL _JAPI mtSetTls(unsigned index, void* val) {return tvmSetTls(index, val);}

inline void _JAPI mtOsNotifyNoApp(void) {tvmNotifyNoApp();}

EXTERN_C_END

#endif //_is_os_thread_H
