/*	file.h

{{IS_NOTE

		Authors:	Henri Chen
		Contributors:
		Create Date:	2000/9/27 10:06AM
		$Header: /cvsroot/jedi/include__tvm__/os/file.h,v 1.2 2000/10/04 04:07:26 henrichen Exp $
		Purpose:	
		Description:	Implmentation header dependant part of file access for tvm
	
}}IS_NOTE

Copyright (C) 2000 Infoshock Corporation. All Rights Reserved.

{{IS_RIGHT
}}IS_RIGHT
*/
#ifndef _is_os_file_H
#define _is_os_file_H

typedef int		_hfile_t;
typedef FILE*	_hfind_t;

#define	FILE_BEGIN		SEEK_SET
#define	FILE_CURRENT	SEEK_CUR
#define	FILE_END		SEEK_END

EXTERN_C_BEGIN

inline unsigned int _JAPI jdbReadFile(
	_hfile_t h, void* data, size_t size)
{
	return ::read(h, data, size);
}

inline unsigned int _JAPI jdbWriteFile(
	_hfile_t h, const void* data, size_t size)
{
	return ::write(h, data, size);
}

inline BOOL _JAPI jdbCloseFile(_hfile_t h)
{
	return ::close(h);
}

inline unsigned long _JAPI jdbSetFilePointer(_hfile_t h, long offset, int pos)
{
	return ::lseek(h, offset, pos);
}

inline BOOL _JAPI jdbSetEndOfFile(_hfile_t h) 
{
	unsigned long len= jdbSetFilePointer(h, 0, FILE_CURRENT);
	return !::ftruncate(h, len);
}

inline BOOL _JAPI jdbDeleteFile(const char *filename)
{
	return !::unlink(filename);
}

inline BOOL _JAPI jdbRenameFile(const char *oldname, const char *newname)
{
	return !::rename(oldname, newname);
}

inline BOOL _JAPI jdbFindClose(_hfind_t h)
{
	return WIFEXITED(::pclose(h));
}

EXTERN_C_END

#define	HFILE_INVALID	-1

#endif //_is_os_file_H
