/*	swab.h

{{IS_NOTE

	Authors:	Tom M. Yeh
	Contributors:
	Create Date:	7/10/0 07:53PM
	$Header: /cvsroot/jedi/include__i486__/cpu/swab.h,v 1.4 2000/07/12 08:52:51 tomyeh Exp $
	Purpose:	Swap byte order between little and big endian for i486
	Description:
	
}}IS_NOTE

Copyright (C) 2000 Infoshock Corporation. All Rights Reserved.

{{IS_RIGHT
}}IS_RIGHT
*/
#ifndef _is_cpu_swab_H
#define _is_cpu_swab_H

#ifndef __LITTLE_ENDIAN__
#error i486 must be little endian
#endif

#ifdef _MSC_VER
#pragma warning(disable: 4035)
#endif

#undef __swab16
inline __u16 __swab16(__u16 x)
{
#ifdef __GNUC__
	__asm__("xchgb %b0,%h0" : "=q" (x) :  "0" (x)); // swap bytes
	return x;
#else
	__asm {
		xor eax, eax
		mov ax, x
		xchg al, ah
	}
#endif
}

#undef __swab32
inline __u32 __swab32(__u32 x)
{
#ifdef __GNUC__
	__asm__("bswap %0" : "=r" (x) : "0" (x));
	return x;
#else
	__asm {
		mov eax, x
		bswap eax
	}
#endif
}

#ifdef _MSC_VER
#pragma warning(default: 4035)
#endif

#undef __swab64
inline __u64 __swab64(__u64 x)
{
	return __swab32((__u32)(x >> 32)) + (((__u64)__swab32((__u32)x)) << 32);
}

#endif //_is_cpu_swab_H
