/*	thread.h

{{IS_NOTE

Authors:	Tom M. Yeh
Contributors:
Create Date:	7/11/0 10:00PM
$Header: /cvsroot/jedi/include__eCos__/os/thread.h,v 1.1 2000/07/14 08:57:42 tomyeh Exp $
Purpose:	thread functions of eCos
Description:

}}IS_NOTE

Copyright (C) 2000 Infoshock Corporation. All Rights Reserved.

{{IS_RIGHT
}}IS_RIGHT
*/
#ifndef _is_os_thread_H
#define _is_os_thread_H

////////////////////////////////////////////////////////
//a List of special feature that applications have to know
#define OS_THREAD_STACK_REQUIRED	//whether mtCreateThread requires a pre-allocated stack
#define OS_THREAD_INFO_REQUIRED		//whether mtCreateThread requires TThreadInfo

////////////////////////////////////////////////////////
#ifndef DEFAULT_SCHED
#define DEFAULT_SCHED	4
#endif

////////////////////////////////////////////////////////
typedef void (*_thread_f)(unsigned);

typedef cyg_thread TThreadInfo;
typedef cyg_handle_t _handle_t;
typedef cyg_tick_count_t _tick_t;

////////////////////////////////////////////////////////
//Thread Functions
EXTERN_C_BEGIN

inline void mtCreateThread(
	_thread_f entry, unsigned data,
	void* stackBase, unsigned stackSize,
	_handle_t* handle, TThreadInfo *thdInfo, unsigned schedInfo)
{cyg_thread_create(schedInfo, entry, data, 0, stackBase, stackSize, handle, thdInfo);}

inline void mtExitThread(void) {cyg_thread_exit();}
inline void mtKillThread(_handle_t hThread) {cyg_thread_kill(hThread);}

inline _handle_t mtGetCurrentThread(void) {return cyg_thread_self();}

inline void mtYield(void) {cyg_thread_yield();}
inline void mtSleep(_tick_t ticks) {cyg_thread_delay(ticks);}

EXTERN_C_END

#endif //_is_os_thread_H
