/*	thread.h

{{IS_NOTE

Authors:	Tom M. Yeh
Contributors:
Create Date:	7/11/0 10:03PM
$Header: /cvsroot/jedi/include__WinCE__/os/thread.h,v 1.10 2000/09/22 11:57:52 tomyeh Exp $
Purpose:	Thread functions of Win/CE
Description:

}}IS_NOTE

Copyright (C) 2000 Infoshock Corporation. All Rights Reserved.

{{IS_RIGHT
}}IS_RIGHT
*/
#ifndef _is_os_thread_H
#define _is_os_thread_H

////////////////////////////////////////////////////////
typedef HANDLE _handle_t;

#define OSTHD_RET_T		DWORD
#define OSTHD_API		WINAPI
#define OSTHD_API_O
#define OSTHD_API_I		OSTHD_API
typedef OSTHD_RET_T OSTHD_API_O(OSTHD_API_I*_osthread_f)(void*);

////////////////////////////////////////////////////////
//Thread
EXTERN_C_BEGIN

inline _handle_t _JAPI mtOsCreateThread(
	_osthread_f entry, void* data, unsigned stackSize, __u32* pThdId)
{
	ASSERT(sizeof(__u32)==sizeof(DWORD));
	return CreateThread(0, stackSize, entry, data, 0, (DWORD*)pThdId);
}

inline void _JAPI mtOsDetachThread(_handle_t hThd) {CloseHandle(hThd);}

inline __u32 _JAPI mtOsGetCurrentThreadId(void) {return GetCurrentThreadId();}

inline void _JAPI mtOsExitThread(void) {ExitThread(0);}
inline void _JAPI mtOsKillThread(_handle_t hThd) {TerminateThread(hThd,0);}

inline void _JAPI mtAnakinSleep(unsigned ticks) {Sleep(ticks * 10);}
inline void _JAPI mtAnakinYield(void) {Sleep(0);}

inline bool _JAPI mtOsWaitThread(_handle_t hThd, unsigned toTicks)
	{return WAIT_TIMEOUT!=WaitForSingleObject(hThd, toTicks==TO_INFINITE ? INFINITE: toTicks*10);}

inline bool _JAPI mtOsSetPriority(_handle_t hThd, int priority)
	{return 0!=SetThreadPriority(hThd, priority + (THREAD_PRIORITY_NORMAL-SCHED_PRIORITY_NORMAL));}
inline int _JAPI mtOsGetPriority(_handle_t hThd)
	{return GetThreadPriority(hThd) - (THREAD_PRIORITY_NORMAL-SCHED_PRIORITY_NORMAL);}

EXTERN_C_END

////////////////////////////////////////////////////////
//Synchronization
typedef CRITICAL_SECTION _mutex_t;
typedef struct __cond_t {
	HANDLE		event;
	_mutex_t	*pMutex;
	unsigned	nWait; //# of waiting threads
} _cond_t;

EXTERN_C_BEGIN

inline void _JAPI mtInitMutex(_mutex_t* mutex) {InitializeCriticalSection(mutex);}
inline void _JAPI mtDestroyMutex(_mutex_t* mutex) {DeleteCriticalSection(mutex);}
inline void _AAPI mtLockMutex(_mutex_t* mutex) {EnterCriticalSection(mutex);}
inline void _AAPI mtUnlockMutex(_mutex_t* mutex) {LeaveCriticalSection(mutex);}

inline void _JAPI mtDestroyCond(_cond_t* cond) {ASSERT(cond); CloseHandle(cond->event);}
inline void _JAPI mtSetCond(_cond_t* cond) {ASSERT(cond); SetEvent(cond->event);}

EXTERN_C_END

////////////////////////////////////////////////////////
//TLS
EXTERN_C_BEGIN
inline unsigned _JAPI mtAllocTls(void) {return TlsAlloc();}
inline BOOL _JAPI mtFreeTls(unsigned index) {return TlsFree(index);}
inline void* _JAPI mtGetTls(unsigned index) {return TlsGetValue(index);}
inline BOOL _JAPI mtSetTls(unsigned index, void* val) {return TlsSetValue(index, val);}
EXTERN_C_END

#endif //_is_os_thread_H
