/*	file.h

{{IS_NOTE

	Authors:	Henri Chen
	Contributors:
	Create Date:	2000/8/11 04:50PM
	$Header: /cvsroot/jedi/include__WinCE__/os/file.h,v 1.3 2000/09/08 01:48:21 henrichen Exp $
	Purpose:	
	Description:	OS dependent part of Jedi's file system

}}IS_NOTE

Copyright (C) 2000 Infoshock Corporation. All Rights Reserved.

{{IS_RIGHT
}}IS_RIGHT
*/
#ifndef _is_os_file_H
#define _is_os_file_H

typedef HANDLE 	_hfile_t;
typedef HANDLE	_hfind_t;

EXTERN_C_BEGIN

inline BOOL _JAPI jdbCloseFile(_hfile_t h)
{
	return ::CloseHandle(h);
}

inline unsigned long _JAPI jdbSetFilePointer(_hfile_t h, long offset, int pos)
{
	return ::SetFilePointer(h, offset, NULL, pos);
}

inline BOOL _JAPI jdbSetEndOfFile(_hfile_t h) 
{
	return ::SetEndOfFile(h);
}

inline BOOL _JAPI jdbDeleteFile(const char *filename)
{
	return ::DeleteFile(_A2T(filename));
}

inline BOOL _JAPI jdbFindClose(_hfind_t hfind)
{
	return ::FindClose(hfind);
}

inline BOOL _JAPI jdbRenameFile(const char *oldname, const char *newname)
{
	return ::MoveFile(_A2T(oldname), _A2T(newname));
}

EXTERN_C_END

#define	HFILE_INVALID	INVALID_HANDLE_VALUE
#endif //_is_os_file_H
