/*	fb.h

{{IS_NOTE

	Authors:	Tom M. Yeh
	Contributors:
	Create Date:	7/13/0 05:35PM
	$Header: /cvsroot/jedi/include__WinCE__/os/fb.h,v 1.6 2000/09/22 11:57:52 tomyeh Exp $
	Purpose:	Frame buffer functions for Win/CE
	Description:
	
}}IS_NOTE

Copyright (C) 2000 Infoshock Corporation. All Rights Reserved.

{{IS_RIGHT
}}IS_RIGHT
*/
#ifndef _is_os_fb_H
#define _is_os_fb_H

////////////////////////////////////////////////////////
#define SCREEN_WIDTH	g_scrnWidth
#define SCREEN_HEIGHT	g_scrnHeight
#define SCREEN_BPP		g_scrnBpp
#define SCREEN_BASEADDR	g_scrnBase

typedef HBITMAP HDIB;

extern int g_scrnWidth, g_scrnHeight, g_scrnBpp;
extern unsigned g_scrnBase;

EXTERN_C_BEGIN

void _STDCALL fbInit(void);
	//To check h/w about screen with, height and bpp
	//This function exists only in the Win/CE version

#ifdef __LITTLE_ENDIAN__
void _STDCALL FbToWinRGB(RGBQUAD rgb[], const TPalette pal[], int n);
#else
inline void FbToWinRGB(RGBQUAD rgb[], const TPalette pal[], int n)
{memcpy(rgb, pal, n * sizeof(RGBQUAD));}
#endif

inline void WinToFbRGB(TPalette pal[], const RGBQUAD rgb[], int n)
{FbToWinRGB((RGBQUAD*)pal, (const TPalette*)rgb, n);}

HDIB _STDCALL fbCreateDIB(int wd, int hgh, int bpp, const TPalette pals[], void** ppBits);
	//Create a DIB
inline void _STDCALL fbDeleteDIB(HDIB hdib) {DeleteObject(hdib);}
	//delete a DIB
	//Note: you don't need to delete the DIB returned by fbConfig
	//Rather call fbCleanup instead.

bool _STDCALL fbSetPaletteEx(HDIB hDIB, const TPalette palettes[],
		int index DEFAULTVAL(0), int nColors DEFAULTVAL(-1));
	//If hDIB is NULL, the frame buffer is assumed, i.e., 
	//the one returned from fbConfig

inline bool _JAPI fbSetPalette(const TPalette palettes[], int index, int nColors)
{return fbSetPaletteEx(0, palettes, index, nColors);}

EXTERN_C_END

#endif //_is_os_fb_H
