/*	file.h

{{IS_NOTE

	Authors:	Joel Sherrill <joel@OARcorp.com>
	Contributors:
	Create Date:	12/13/2000
	$Header$
	Purpose:	
	Status:		No changes yet.
	Description:	Implementation header dependent part of file
			access for RTEMS
	
}}IS_NOTE

Original File:
	Copyright (C) 2000 Infoshock Corporation. All Rights Reserved.
RTEMS Port:
	Copyright (C) 2000 OAR Corporation.

{{IS_RIGHT
}}IS_RIGHT
*/
#ifndef _is_os_file_H
#define _is_os_file_H

typedef int	_hfile_t;
typedef FILE*	_hfind_t;

#define	FILE_BEGIN	SEEK_SET
#define	FILE_CURRENT	SEEK_CUR
#define	FILE_END	SEEK_END

EXTERN_C_BEGIN

inline unsigned int _JAPI jdbReadFile(
  _hfile_t h, void* data, size_t size)
{
  return ::read(h, data, size);
}

inline unsigned int _JAPI jdbWriteFile(
  _hfile_t h, const void* data, size_t size)
{
  return ::write(h, data, size);
}

inline BOOL _JAPI jdbCloseFile(_hfile_t h)
{
  return ::close(h);
}

inline unsigned long _JAPI jdbSetFilePointer(_hfile_t h, long offset, int pos)
{
  return ::lseek(h, offset, pos);
}

inline BOOL _JAPI jdbSetEndOfFile(_hfile_t h) 
{
  unsigned long len= jdbSetFilePointer(h, 0, FILE_CURRENT);
  return !::ftruncate(h, len);
}

inline BOOL _JAPI jdbDeleteFile(const char *filename)
{
  return !::unlink(filename);
}

inline BOOL _JAPI jdbRenameFile(const char *oldname, const char *newname)
{
  return !::rename(oldname, newname);
}

inline BOOL _JAPI jdbFindClose(_hfind_t h)
{
  return WIFEXITED(::pclose(h));
}

EXTERN_C_END

#define	HFILE_INVALID	-1

#endif //_is_os_file_H
