/*	types.h

{{IS_NOTE

	Authors:	Joel Sherrill <joel@OARcorp.com>
	Contributors:
	Create Date:	12/13/2000
	$Header$
	Purpose:	Types of RTEMS
	Description:	Required includes for port.

}}IS_NOTE

Original File:
	Copyright (C) 2000 Infoshock Corporation. All Rights Reserved.
RTEMS Port:
	Copyright (C) 2000 OAR Corporation.

{{IS_RIGHT
}}IS_RIGHT
*/
#ifndef _is_os_types_H
#define _is_os_types_H

#include <rtems.h>

// Since RTEMS provides a totally portable interface we can rely on
// it to define these primitive types.
typedef rtems_signed8 __s8;
typedef rtems_unsigned8 __u8;

typedef rtems_signed16 __s16;
typedef rtems_unsigned16 __u16;

typedef rtems_signed32 __s32;
typedef rtems_unsigned32 __u32;

#ifdef __GNUC__
typedef rtems_signed64 __s64;
typedef rtems_unsigned64 __u64;
#else
#error "RTEMS and not on GNU C.. fix me"
#endif

#define BITS_PER_LONG 32

// size_t is defined in <stddef.h> provided by GNU C 
#include <stddef.h>

#endif //_is_os_types_H
