/*	swab.h

{{IS_NOTE

	Authors:	Joel Sherrill <joel@OARcorp.com>
	Contributors:
	Create Date:	12/13/2000
	$Header$
	Status:		Pending question on whether this always swaps to
		non-native endian or from native endian-ness to big endian
		(which might be a NULL operation).
	Purpose:	Swap byte order between little and big endian for RTEMS
	Description:
	
}}IS_NOTE

Original File:
	Copyright (C) 2000 Infoshock Corporation. All Rights Reserved.
RTEMS Port:
	Copyright (C) 2000 OAR Corporation.

{{IS_RIGHT
}}IS_RIGHT
*/
#ifndef _is_cpu_swab_H
#define _is_cpu_swab_H

#include <rtems.h>

#undef __swab16
inline __u16 __swab16(__u16 x) {
#if CPU_LITTLE_ENDIAN
  return CPU_swap_u16( x );
#else
  return x;
#endif
}

#undef __swab32
inline __u32 __swab32(__u32 x)
{
#if CPU_LITTLE_ENDIAN
  return CPU_swap_u32( x );
#else
  return x;
#endif
}

#undef __swab64
inline __u64 __swab64(__u64 x)
{
#if CPU_LITTLE_ENDIAN
  return __swab32((__u32)(x >> 32)) + (((__u64)__swab32((__u32)x)) << 32);
#else
  return x;
#endif
}

#endif //_is_cpu_swab_H
