/*	tvm.h

{{IS_NOTE

	Authors:	Tom M. Yeh
	Contributors:
	Create Date:	6/7/0 02:48PM
	$Header: /cvsroot/jedi/include/tvm/tvm.h,v 1.23 2000/10/12 09:15:03 tomyeh Exp $
	Purpose:	The main header of tvm.dll
	Description:
		It defines all exported functions
	
}}IS_NOTE

Copyright (C) 2000 Infoshock Corporation. All Rights Reserved.

{{IS_RIGHT
}}IS_RIGHT
*/
#ifndef _is_tvm_tvm_H
#define _is_tvm_tvm_H

#include <stdarg.h>

// extern TVM_API int export_var;
// TVM_API int export_func(void);
// class TVM_API CExported {...};
#ifdef TVM_EXPORTS
#define TVM_API __declspec(dllexport)
#else
#ifdef __GNUC__
#define TVM_API
#else
#define TVM_API __declspec(dllimport)
#endif
#endif

#ifndef EXTERN_C
#ifdef __cplusplus
#define	EXTERN_C			extern "C"
#else
#define EXTERN_C
#endif
#endif

#ifndef DEFAULTVAL
#define DEFAULTVAL(val)
#endif

#ifdef _MSC_VER
#define _STDCALL	__stdcall
#define _CDECL		__cdecl
#define _CDECL_O
#define _CDECL_I	_CDECL
#else
#define _STDCALL	__attribute__((stdcall))
#define _CDECL		__attribute__((cdecl))
#define _CDECL_O	_CDECL
#define _CDECL_I
#endif //_MSC_VER

#define _CDECL_PF(Fn)	_CDECL_O (_CDECL_I* Fn)

typedef void* HDIB; //equivalent to HBITMAP, but don't let caller know

///////////////////////////////////////////////////////////
#define TO_INFINITE					0xffffffff //infinite timeout

#define SCHED_PRIORITY_TIME_CRITICAL	-3
#define SCHED_PRIORITY_HIGHEST			-2
#define SCHED_PRIORITY_ABOVE_NORMAL		-1
#define SCHED_PRIORITY_NORMAL			0
#define SCHED_PRIORITY_BELOW_NORMAL		1
#define SCHED_PRIORITY_LOWEST			2
#define SCHED_PRIORITY_ABOVE_IDLE		3
#define SCHED_PRIORITY_IDLE				4

///////////////////////////////////////////////////////////
// Data structures
struct tvm_info {
	int scrn_cx;
	int scrn_cy;
	unsigned char bpp; //bits per pixels; 1, 2, 4, 8, 16, 32
	unsigned char scale; //0 for 1:1, 1 for 1:2
};

#ifndef _is_jedi_types_H
struct TPoint {
	short x,y;
};

struct TRect {
	TPoint leftTop, extent;
};
#endif

///////////////////////////////////////////////////////////
typedef void* pthread_t;
typedef void _CDECL_PF(pthread_f)(void*);

typedef struct tvmmutex_t* pthread_mutex_t;
typedef struct tvmcond_t*  pthread_cond_t;

///////////////////////////////////////////////////////////
// Init and Debug API
EXTERN_C TVM_API bool _CDECL tvmInit(
	void (*notifyfn)(int evt,unsigned param1, unsigned param2),
	void (*abortfn)(void));
	//Initialize TVM
	//notifyfn is the function to notify a key/button is pressed or 
	//	styler is moved. See evtOnHwNotify in jedi/event.h
	//abortfn is the function to call when aborting, It cannot be null.
	//	return TRUE for success
	//.............
	//The execution flow:
	//	tvmInit
	//	tvmFbConfig
	//	create other threads
	//	tvmStart
	//	exit

EXTERN_C TVM_API bool _CDECL tvmStart(void);
	//Create debug windows and start TVM.
	//It won't return until the windows are closed
	//After return, the whole system shall stop
	//Normally, you start TVM after calling tvmInit and tvmFbConfig

EXTERN_C TVM_API void _CDECL tvmTrace(const char* extra, const char* fmt, va_list valist);
	//Print a message, prefix with an extra message, to the trace window
	//If extra is null, it is ignored
	//If fmt is null, all following arguments are ignored

EXTERN_C TVM_API void _CDECL tvmNotifyNoApp(void);

EXTERN_C TVM_API unsigned _CDECL tvmGetCurrentTicks(void);

///////////////////////////////////////////////////////////
//Thread
EXTERN_C TVM_API pthread_t _CDECL tvmCreateThread(
	pthread_f func, void *param, unsigned nStackSize, unsigned *pThdId);
	//return the handle of the thread if succeed
	//return NULL if failed
EXTERN_C TVM_API void _CDECL tvmDetachThread(pthread_t hThd);

EXTERN_C TVM_API unsigned _CDECL tvmGetCurrentThreadId(void);

EXTERN_C TVM_API void _CDECL tvmExitThread(void);
	//exit the current thread
EXTERN_C TVM_API void _CDECL tvmKillThread(pthread_t hThd);
	//kill the specified thread

EXTERN_C TVM_API void _CDECL tvmSleep(unsigned ticks);
	//Yield execution and sleep for specified ticks.
	//100 ticks per second
EXTERN_C TVM_API void _CDECL tvmYield(void);
	//yield execution to another thread

EXTERN_C TVM_API bool _CDECL tvmWaitThread(pthread_t hThd, unsigned toTicks);

EXTERN_C TVM_API bool _CDECL tvmSetThreadPriority(pthread_t hThd, int priority);
EXTERN_C TVM_API int _CDECL tvmGetThreadPriority(pthread_t hThd);

EXTERN_C TVM_API void _CDECL tvmInitMutex(pthread_mutex_t *pMutex);
EXTERN_C TVM_API void _CDECL tvmDestroyMutex(pthread_mutex_t *pMutex);
EXTERN_C TVM_API void _CDECL tvmLockMutex(pthread_mutex_t *pMutex);
EXTERN_C TVM_API void _CDECL tvmUnlockMutex(pthread_mutex_t *pMutex);

EXTERN_C TVM_API void _CDECL tvmInitCond(pthread_cond_t *pCond, pthread_mutex_t *pMutex);
EXTERN_C TVM_API void _CDECL tvmDestroyCond(pthread_cond_t *pCond);
EXTERN_C TVM_API void _CDECL tvmSetCond(pthread_cond_t *pCond);
	//TVM does not support broadcast
EXTERN_C TVM_API bool _CDECL tvmWaitCond(pthread_cond_t *pCond, unsigned toTicks DEFAULTVAL(TO_INFINITE));
	//return true if succeed; false if timeout

EXTERN_C TVM_API unsigned _CDECL tvmAllocTls(void);
EXTERN_C TVM_API BOOL _CDECL tvmFreeTls(unsigned index);
EXTERN_C TVM_API void* _CDECL tvmGetTls(unsigned index);
EXTERN_C TVM_API BOOL _CDECL tvmSetTls(unsigned index, void* val);

///////////////////////////////////////////////////////////
//Fb API
EXTERN_C TVM_API HDIB _CDECL tvmFbConfig(
	const struct tvm_info* ti, const unsigned colors[], unsigned* baseAddr);
	//colors must contain 2^bpp entries if bpp <= 8
	//return nonzero (the bitmap handle) if success
	//return 0 if failed
	//Note: tvmFbConfig must be called

EXTERN_C TVM_API bool _CDECL tvmFbSetPaletteLE(const unsigned colors[],
	int index DEFAULTVAL(0), int nColors DEFAULTVAL(-1));
	//Set the color table
	//index: the first palette entry to change, i.e., colors[index]
	//nColors: # of colors in colors[]. If -1, it means up to the
	//	last palette entry.
EXTERN_C TVM_API bool _CDECL tvmFbSetPaletteBE(const unsigned colors[],
	int index DEFAULTVAL(0), int nColors DEFAULTVAL(-1));
	//Same as tvmFbSetpaletteLE except colors is assumed to be big endian

EXTERN_C TVM_API void _CDECL tvmFbSync(bool bSync);
	//Set whether the update of frame buffer is reflected to screen
	//immediately.
	//Default: synchronous

EXTERN_C TVM_API void _CDECL tvmFbUpdate(const TRect* rect);
	//Inform the window to repaint the specified range
	//If rect==0, the whole window is repaint

///////////////////////////////////////////////////////////
//Memory
EXTERN_C TVM_API void* _CDECL tvmAlloc(unsigned sz);
EXTERN_C TVM_API void* _CDECL tvmRealloc(void* p, unsigned sz);
EXTERN_C TVM_API void _CDECL tvmFree(void* p);
EXTERN_C TVM_API unsigned _CDECL tvmMSize(void* p);
EXTERN_C TVM_API void _CDECL tvmMemInfo(unsigned *szRom, unsigned *szRam, unsigned *szRamAvail);

///////////////////////////////////////////////////////////
//Loader
typedef void* _tvmDll_t;
typedef void (*_tvmDll_f)(void);
EXTERN_C TVM_API _tvmDll_t tvmDllOpen(const char*);
EXTERN_C TVM_API void tvmDllClose(_tvmDll_t);
EXTERN_C TVM_API _tvmDll_f tvmDllGet(_tvmDll_t, const char*);

#endif //_is_tvm_tvm_H
