/*	strutl.h

{{IS_NOTE

	Authors:	Tom M. Yeh
	Contributors:
	Create Date:	8/28/0 10:27AM
	$Header: /cvsroot/jedi/include/lib/strutl.h,v 1.5 2000/09/22 11:57:52 tomyeh Exp $
	Purpose:	String utilities
	Description:
	
}}IS_NOTE

Copyright (C) 2000 Infoshock Corporation. All Rights Reserved.

{{IS_RIGHT
}}IS_RIGHT
*/
#ifndef _is_lib_strutl_H
#define _is_lib_strutl_H

char* _JAPI strext(char* str, const char* ext);
	//return str, which will be str + '.' + ext
	//(the previous extension, if any, will be removed first)
	//If ext[0]='.', it will be ignored
	//If ext==0, no extension will be added; not even '.'
	//if ext[0]==0, a null extension is added; i.e., 'name.'
	//It assumes str has enough room

void _JAPI strupd(char **dst, const char *src);
	//free(*dst) and *dst = strdup(src)
	//if dst==0, nothing happens

#ifdef __WinCE__
char* _JAPI dbpath(const char* dbname);
	//Transfer a db name into a full path. Useful only in CE
	//Note: dbpath uses a global buffer to hold the transferred path
	//Caller don't need to free it but you shall not hold it cross
	//function boundary since other function might use it, too
	//To preserve the value, you might call STRDUP.
char* _JAPI dbbase(char* dbpth);
	//The reverse function of dbpath
#else
inline const char* _JAPI dbpath(const char* dbname) {return dbname;}
inline char* _JAPI dbbase(char* dbpth) {return dbpth;}
#endif

inline const char* _JAPI dbbase(const char* dbpth)
	{return (const char*)dbbase((char*)dbpth);}
#endif //_is_lib_strutl_H
