/*	rbtree.h

{{IS_NOTE

	Authors:	Henri Chen
	Contributors:
	Create Date:	2000/9/1 01:32PM
	$Header: /cvsroot/jedi/include/lib/rbtree.h,v 1.1 2000/09/06 06:08:43 henrichen Exp $
	Purpose:	
	Description:	
		1. Implementation of RBTree(Ref. chap 13,14 "Introduction to 
		   Algorithms" by Cormen etl.)
		2. How to use this class?
			2.1. Public derive your tree node from CRBNode
			2.2. Public derive your tree from CRBTree and provide the two 
				 pure virtual functions.
			2.3. Define your "key" class or data structure so it can be used to compare
				 between your key and your tree node.

}}IS_NOTE

Copyright (C) 2000 Infoshock Corporation. All Rights Reserved.

{{IS_RIGHT
}}IS_RIGHT
*/
#ifndef _is_lib_rbtree_H
#define _is_lib_rbtree_H

class CRBNode {
public:
	CRBNode() : m_left(NULL), m_right(NULL), m_flags(0) {}
	void Set(unsigned mask, bool bSet);
	inline bool IsSet(unsigned mask);
	inline bool IsRed(void);
	inline bool IsBlack(void);
	inline void SetColor(bool bRed);
	inline void SetRed(void);
	inline void SetBlack(void);
	
	//data
	CRBNode *m_left, *m_right;
	unsigned m_flags;
};

//CRBNode.m_flags
#define	RBNODEFLAGS_RED	0x1

inline bool CRBNode::IsSet(unsigned mask)
{
	return (m_flags & mask) != 0;
}

inline bool CRBNode::IsRed(void)
{
	return IsSet(RBNODEFLAGS_RED);
}

inline bool CRBNode::IsBlack(void)
{
	return !IsRed();
}

inline void CRBNode::SetColor(bool bRed)
{
	Set(RBNODEFLAGS_RED, bRed);
}

inline void CRBNode::SetRed(void)
{
	SetColor(true);
}

inline void CRBNode::SetBlack(void)
{
	SetColor(false);
}


//////////////////////////////////////////////////////////////////
class CRBTree {
public:
	CRBTree():m_root(NULL){}
	virtual int Comp(void *key, CRBNode *node)= 0;
		//compare between key and node. It is used in all tree functions.
		//if key < node, return a value small than 0. The tree will go to left child.
		//if key == node, return 0. This means the key is found.
		//if key > node, return a value big than 0. The tree will go to its right child.
		
	virtual void Copy(CRBNode *dst, CRBNode *src)= 0;
		//This is used in detach node in case the detached node has two children
		//Copy the contents except those in CRBNode (e.g. m_left, m_right,
		//to m_flags, etc) from src to dst.

	void Attach(CRBNode *, void *key);
		//attach a node onto the tree.
	CRBNode *Detach(void *key);
		//detach a node from the tree. If not found, return NULL.
	CRBNode *Search(void *key);
		//search a node in the tree. If not found, return NULL.

#ifndef NDEBUG
	bool Check(void);
	bool CheckNode(CRBNode *, CRBNode *, unsigned *bn);
#endif	//!NDEBUG
		
protected:
	void LeftRotate(CRBNode *pa, CRBNode *x);
	void RightRotate(CRBNode *pa, CRBNode *x);
	void Insert(CRBNode *root, CRBNode *z, void *key, CRBNode *ggpa, CRBNode *gpa, CRBNode *pa, CRBNode **nextX);
	void InsertFix(CRBNode *ggpa, CRBNode *gpa, CRBNode *pa, CRBNode *x, CRBNode **nextX);
	CRBNode *Delete(CRBNode *root, void *key, CRBNode *gpa, CRBNode *pa, CRBNode **nextX);
	void DeleteFix(CRBNode *gpa, CRBNode *pa, CRBNode *x, CRBNode **nextX, bool bLeft);
	
	//data
	CRBNode *m_root;
};

#endif //_is_lib_rbtree_H
