/*	ownlink.h

{{IS_NOTE

	Authors:	Tom M. Yeh
	Contributors:
	Create Date:	8/28/0 10:29AM
	$Header: /cvsroot/jedi/include/lib/ownlink.h,v 1.6 2000/09/26 10:09:26 tomyeh Exp $
	Purpose:	TOwnLink
	Description:
		TOwnLink is used as a template to make a struct a linked list
		such that it can be cleanup by giving the owner (i.e., thread id).
	Use:
		//header
		DECL_OWNLINK(TMyEx, TMy)
		//source
		DEF_OWNLINK(TMyEx)
		//convert
		TMy* q = ToTMy(p); //assumes TMyEx* p
		TMyEx* p = ToTMyEx(q);
		//create
		TMyEx* p = _MALLOC_T(TMyEx);
		if(p){
			...
			p->Link();
		}
		return ToTMy(p); //usually store TMy* instead of TMyEx
		//destroy
		ToTMyEx(p)->Unlink();
		_FREE(ToTMyEx(p));
		//app cleanup
		TMyEx::Apply(owner, myDestroy); //NOTE: myDestroy operators on TMy!!
	Note:
		See the comment in lib/link.h.
		So far, no one uses TOwnLink but it won't increase the code size
		because it is part of libutl.lib.
}}IS_NOTE

Copyright (C) 2000 Infoshock Corporation. All Rights Reserved.

{{IS_RIGHT
}}IS_RIGHT
*/
#ifndef _is_lib_ownlink_H
#define _is_lib_ownlink_H

//////////////////////////////////////////////////////////
struct TolInfo {
	TolInfo*	_ol_next;
	__u32		_ol_owner;
};

typedef void _AAPI_PF(_olapply_f)(void*);
EXTERN_C TolInfo* _JAPI _olUnlink(TolInfo* list, TolInfo* obj);
EXTERN_C void _JAPI _olApply(TolInfo* list, __u32 owner, _olapply_f pf);

//////////////////////////////////////////////////////////
template<class T>
struct TOwnLink : public TolInfo, public T {
	static TolInfo* _s_list;

	inline void Link() {
		_ol_next	= s_list;
		_s_list		= this;
		_ol_owner	= mtGetCurrentProcess();
	}

	inline void Unlink() {_s_list = (TOwnLink*)_olUnlink(_s_list, this);}
	typedef void _AAPI_PF(_apply_f)(T*);
	static inline void Apply(__u32 owner, _apply_f pf) {_olApply(_s_list, owner, (_olapply_f)pf);}
};

#define DECL_OWNLINK(TMyEx, TMy)	\
	typedef TOwnLink<TMy> TMyEx;	\
	inline TMyEx* To##TMyEx(TMy* p) {return (TMyEx*)(((char*)p) - sizeof(TolInfo));} \
	inline TMy* To##TMy(TMyEx* p) {return (TMy*)(((char*)p) + sizeof(TolInfo));}

#define DEF_OWNLINK(TMyEx, TMy)		TMyEx* TMyEx::_s_list;

#endif //_is_lib_ownlink_H
