/*	mrbtree.h

{{IS_NOTE

	Authors:	Henri Chen
	Contributors:
	Create Date:	2000/9/1 01:32PM
	$Header: /cvsroot/jedi/include/lib/mrbtree.h,v 1.1 2000/10/05 07:22:15 henrichen Exp $
	Purpose:	
	Description:	
		1. Implementation of RBTree(Ref. chap 13,14 "Introduction to 
		   Algorithms" by Cormen etl.)
		2. How to use this class?
			2.1. Public derive your tree node from CMRBNode
			2.2. Public derive your tree from CMRBTree and provide the two 
				 pure virtual functions.
			2.3. Define your "key" class or data structure so it can be used to compare
				 between your key and your tree node.

}}IS_NOTE

Copyright (C) 2000 Infoshock Corporation. All Rights Reserved.

{{IS_RIGHT
}}IS_RIGHT
*/
#ifndef _is_lib_rbtree_H
#define _is_lib_rbtree_H

class CMRBNode {
public:
	CMRBNode() : m_left(NULL), m_right(NULL), m_flags(0) {}
	void Set(unsigned mask, bool bSet);
	inline bool IsSet(unsigned mask);
	inline bool IsRed(void);
	inline bool IsBlack(void);
	inline void SetColor(bool bRed);
	inline void SetRed(void);
	inline void SetBlack(void);
	
	//data
	CMRBNode *m_left, *m_right;
	unsigned m_flags;
};

//CMRBNode.m_flags
#define	RBNODEFLAGS_RED	0x1

inline bool CMRBNode::IsSet(unsigned mask)
{
	return (m_flags & mask) != 0;
}

inline bool CMRBNode::IsRed(void)
{
	return IsSet(RBNODEFLAGS_RED);
}

inline bool CMRBNode::IsBlack(void)
{
	return !IsRed();
}

inline void CMRBNode::SetColor(bool bRed)
{
	Set(RBNODEFLAGS_RED, bRed);
}

inline void CMRBNode::SetRed(void)
{
	SetColor(true);
}

inline void CMRBNode::SetBlack(void)
{
	SetColor(false);
}


//////////////////////////////////////////////////////////////////
class CMRBTree {
public:
	CMRBTree():m_root(NULL){}
	virtual int Comp(void *key, CMRBNode *node)= 0;
		//compare between key and node. It is used in all tree functions.
		//if key < node, return a value small than 0. The tree will go to left child.
		//if key == node, return 0. This means the key is found.
		//if key > node, return a value big than 0. The tree will go to its right child.
		
	virtual void Copy(CMRBNode *dst, CMRBNode *src)= 0;
		//This is used in detach node in case the detached node has two children
		//Copy the contents except those in CMRBNode (e.g. m_left, m_right,
		//to m_flags, etc) from src to dst.

	void Attach(CMRBNode *, void *key);
		//attach a node onto the tree.
	CMRBNode *Detach(void *key);
		//detach a node from the tree. If not found, return NULL.
	CMRBNode *Search(void *key);
		//search a node in the tree. If not found, return NULL.

#ifndef NDEBUG
	bool Check(void);
	bool CheckNode(CMRBNode *, CMRBNode *, unsigned *bn);
#endif	//!NDEBUG
		
protected:
	void LeftRotate(CMRBNode *pa, CMRBNode *x);
	void RightRotate(CMRBNode *pa, CMRBNode *x);
	void Insert(CMRBNode *root, CMRBNode *z, void *key, CMRBNode *ggpa, CMRBNode *gpa, CMRBNode *pa, CMRBNode **nextX);
	void InsertFix(CMRBNode *ggpa, CMRBNode *gpa, CMRBNode *pa, CMRBNode *x, CMRBNode **nextX);
	CMRBNode *Delete(CMRBNode *root, void *key, CMRBNode *gpa, CMRBNode *pa, CMRBNode **nextX);
	void DeleteFix(CMRBNode *gpa, CMRBNode *pa, CMRBNode *x, CMRBNode **nextX, bool bLeft);
	
	//data
	CMRBNode *m_root;
};

#endif //_is_lib_rbtree_H
