/*	win.h

{{IS_NOTE

	Authors:	Henri Chen, Tom M. Yeh
	Contributors:
	Create Date:	2000/7/24 09:17PM
	$Header: /cvsroot/jedi/include/jedi/win.h,v 1.14 2000/10/11 07:48:57 henrichen Exp $
	Purpose:	
	Description:	Implementation Header of Jedi's winXXX() functions

}}IS_NOTE

Copyright (C) 2000 Infoshock Corporation. All Rights Reserved.

{{IS_RIGHT
}}IS_RIGHT
*/
#ifndef _is_jedi_win_H
#define _is_jedi_win_H

#include <jedi/mem.h>

///////////////////////////////////////////////////////////
//data types defined in other headers
struct TBmp;
struct TFont;

///////////////////////////////////////////////////////////
typedef struct TDrawState {
	__s16	transferMode;
	__s16	pattern;
	__s16	underlineMode;
	__s16	fontId;
	TFont	*pFont;
	__u8	patternData[8];
	__u8	foreColor;
	__u8	backColor;
	__u8	textColor;

	inline void InitToZero(void) {memset(this, 0, sizeof(TDrawState));}
} TDrawState;

//TDrawState.transferMode
#define	DSMODE_PAINT		0
#define	DSMODE_ERASE		1
#define	DSMODE_MASK			2
#define	DSMODE_INVERT		3
#define	DSMODE_OVERLAY		4
#define	DSMODE_PAINTINVERSE	5
#define	DSMODE_SWAP			6

//TDrawState.pattern
#define	DSPATTERN_BLACK		0
#define	DSPATTERN_NONE		DSPATTERN_BLACK
#define	DSPATTERN_WHITE		1
#define	DSPATTERN_GRAY		2
#define	DSPATTERN_CUSTOM	3

//TDrawState.underlineMode
#define	DSUNDERLINE_NONE	0
#define	DSUNDERLINE_GRAY	1
#define	DSUNDERLINE_SOLID	2
#define	DSUNDERLINE_COLOR	3

///////////////////////////////////////////////////////////
typedef struct TFrameBits {
	__u16 _BF5(
		cornerDiam	:8,
		reserved_3	:3,
		threeD		:1,
		shadowWidth	:2,
		width		:2);

	DECL_SETZEROS(__u16)
} TFrameBits;

typedef struct TWinFlags {
	__u16 _BF9(
		format		:1,
		offscreen	:1,
		modal		:1,
		focusable	:1,
		enabled		:1,
		visible		:1,
		dialog		:1,
		freeBitmap	:1,
		reserved	:8);

	DECL_SETZEROS(__u16)
} TWinFlags;

typedef struct TWin {
	__s16		displayWidthV20;
	__s16		displayHeightV20;

	//void		*displayAddrV20; //Jedi replace it with the owner field
	__u32		owner;	//with this field to store owner

	TWinFlags	flags;
	TRect		bounds;
	TAbsRect	clippingBounds;
	TBmp		*pBitmap;
	__u16		frameType;
	void		*_pDrawState_; //keep it for Palm but Jedi doesn't use it internally
	struct TWin	*next;
} TWin;
typedef struct TWin *_hwin_t;
extern TWin g_winScrn, *g_pWinList, *g_pWinActive, *g_pWinActivePrev;

//TWin.frameType
#define	WINFRAME_NO			0
#define	WINFRAME_SIMPLE		1
#define	WINFRAME_RECT		WINFRAME_SIMPLE
#define	WINFRAME_3D			0x0012	// 3d, width = 2
#define	WINFRAME_ROUND		0x0401	// corner =	4, width = 1
#define	WINFRAME_BOLDROUND	0x0702	// corner =	7, width = 2
#define	WINFRAME_POPUP		0x0205	// corner =	2, width = 1, shadow = 1
#define	WINFRAME_DIALOG		0x0302	// corner =	3, width = 2
#define	WINFRAME_MENU		WINFRAME_POPUP

//Scrolling direction
#define	WINDIR_UP			0
#define	WINDIR_DOWN			1
#define	WINDIR_LEFT			2
#define	WINDIR_RIGHT		3

///////////////////////////////////////////////////////////
//Anakin-matched API
EXTERN_C TWin* _AAPI winCreateOffscreen(TBmp* pBmp, _err_t* err);
	//create a offscreen TWin
EXTERN_C TWin* _AAPI winCreateOffscreenEx(__s16 width, __s16 height, __s16 bGenericFormat, _err_t* err);
	//format is ignored
EXTERN_C TWin* _AAPI winCreate(TRect* bound, __s16 frameType, bool bModal, bool bFocusable, __u16* err);
	//create a display TWin

EXTERN_C TWin* _AAPI winGetDrawWindow(void); //never return null
EXTERN_C TWin* _AAPI winSetDrawWindow(TWin* pWin);
	//if pWin==0, draw window is set to screen window

EXTERN_C void _AAPI winSetActive(TWin* pWin);

EXTERN_C void _AAPI winPushDrawState(void);
EXTERN_C void _AAPI winPopDrawState(void);

EXTERN_C void _AAPI winGetClip(TRect *pRect);
	//Get the clipping rectangle of the draw window
EXTERN_C void _AAPI winSetClip(const TRect *pRect);
	//Set the clipping rectangle of the draw window
EXTERN_C void _AAPI winResetClip(void);
	//Reset the clipping rectangle of the window to be the part which show on the screen.
EXTERN_C void _AAPI winClipRect(TRect *pRect);
	//Shrink the rectangle to make it fit within the clipping region

EXTERN_C void _AAPI winSetBounds(TWin *pWin, const TRect *pRect);
	//Set window's new postion and dimension.
EXTERN_C void _AAPI winGetBounds(TRect *pRect);
	//Get the bound of the draw window

EXTERN_C void _AAPI winGetFrameRect(__u16 frame, const TRect *pInterior, TRect *pFrame);
	//Get the Frame rect of a specified rectangle

EXTERN_C void _AAPI winCopyRect(TWin* pSrc, TWin* pDst, const TRect* pRect,
	__s16 dstX, __s16 dstY, __s16 mode);
	//blit a rectangle from source to destination window
EXTERN_C TWin* _AAPI winSaveBits(const TRect* pRect, __u16 *err);
	//allocate a window, save the bits of the pRect of the current draw windows to it
EXTERN_C void _AAPI winRestoreBits(TWin *wh, __s16 x, __s16 y);
	//restore the bits of the window to (x,y) of the current draw window, free the window
	
///////////////////////////////////////////////////////////
//Jedi Only API
EXTERN_C void _JAPI winDestroy(TWin *pWin, bool bDelWin = true);
	//Destroy a window
EXTERN_C void _JAPI winBindAndInit(TWin* pWin, TBmp* pBmp, const TRect *pBound=0);
	//Bind and inital a created window with a bmp
	//if pBound==0, the bitmap size is used
	//It is called by winCreatexxx
	//Don't call it in other place

EXTERN_C TDrawState* _JAPI winGetDrawState(void);

EXTERN_C void _JAPI WinToScreen(const TWin *pWin, __s16 *x, __s16 *y);
EXTERN_C void _JAPI ScreenToWin(const TWin *pWin, __s16 *x, __s16 *y);
	//Transform the coordinates(x,y) from window to screen and vice versa
EXTERN_C void _JAPI winErase(TWin *pWin, TDrawState *pDs);
	//Erase(fill with current backgound color) the window if it is on screen
EXTERN_C void _JAPI winDrawFrame(__u16 frameType, const TRect *pRect, TDrawState *pDs);
	//Draw the frame of the current draw window
EXTERN_C void _JAPI winDrawBitmap(TBmp *pBmp, __s16 x, __s16 y, TDrawState *pDs);
	//Draw the bitmap of the current draw window	
EXTERN_C void _JAPI winAppCleanup(__u32 owner);

#endif //_is_jedi_win_H
