/*	types.h

{{IS_NOTE

	Authors:	Tom M. Yeh
	Contributors:
	Create Date:	6/15/0 10:00PM
	$Header: /cvsroot/jedi/include/jedi/types.h,v 1.11 2000/09/05 06:38:33 tomyeh Exp $
	Purpose:	types used by Jedi
	Description:
	Notes:
		1. Only basic types are defined here. Types depending on different
		functions, such as TMutex, are defined in their own header,
		e.g., thread.h. Reason: better project management.
		If you thought to add types here, you have to think twice whether
		any other header to put these types.
}}IS_NOTE

Copyright (C) 2000 Infoshock Corporation. All Rights Reserved.

{{IS_RIGHT
}}IS_RIGHT
*/
#ifndef _is_jedi_types_H
#define _is_jedi_types_H

#include <jedi/defs.h>
#include <cpu/types.h>
#include <os/types.h>

/////////////////////////////////////////////////////////////
typedef unsigned size_t;

#ifndef TRUE
#define TRUE	1
#endif
#ifndef FALSE
#define FALSE	0
#endif
typedef int BOOL;

/////////////////////////////////////////////////////////////
struct TPalette {
	__u8 index, r, g, b;
};

/////////////////////////////////////////////////////////////
struct TPoint {
	__s16 x,y;
};

struct TRect {
	TPoint leftTop, extent;

#ifdef __cplusplus
	inline __s16 Left() const {return leftTop.x;}
	inline __s16 Top() const {return leftTop.y;}
	inline __s16& Left() {return leftTop.x;}
	inline __s16& Top() {return leftTop.y;}

	inline __s16 Right() const {return (__s16) (leftTop.x + extent.x);}
	inline __s16 Bottom() const {return (__s16) (leftTop.y + extent.y);}

	inline __s16 Width() const {return extent.x;}
	inline __s16 Height() const {return extent.y;}
	inline __s16& Width() {return extent.x;}
	inline __s16& Height() {return extent.y;}
#endif
};

//NOTE: TAbsRect is a very special type where right/bottom egdges
//are visible, such that we can provide the compatibility to Palm
//However, in all other places, e.g,,TRect::Right() and Bottom(),
//are not visible, similar to MS Windows
struct TAbsRect {
	__s16	left, top, right, bottom;

#ifdef __cplusplus
	inline __s16 Width() const	{return (__s16)(right-left+1);}
	inline __s16 Height() const	{return (__s16)(bottom-top+1);}
#endif
};

#ifdef __cplusplus
inline void CopyRect(TRect* dst, const TAbsRect* src)
{
	dst->Left()		= src->left;
	dst->Top()		= src->top;
	dst->Width()	= src->Width();
	dst->Height()	= src->Height();
}

inline void CopyRect(TAbsRect* dst, const TRect* src)
{
	dst->left		= src->Left();
	dst->top		= src->Top();
	dst->right		= (__s16)(src->Right() -1);
	dst->bottom		= (__s16)(src->Bottom() -1);
}
#endif

/////////////////////////////////////////////////////////////
typedef __u16		wchar_t;
typedef unsigned	_err_t;

#ifdef _UNICODE
#define P_TS	"%ls"
typedef wchar_t	TCHAR;
#else //_UNICODE
#define P_TS	"%s"
typedef char	TCHAR;
#endif //_UNICODE

typedef TCHAR* LPTSTR;
typedef const TCHAR* LPCTSTR;
typedef wchar_t* LPWSTR;
typedef const wchar_t* LPCWSTR;
typedef char* LPSTR;
typedef const char* LPCSTR;

struct TEvent;

#endif //_is_jedi_types_H
