/*	time.h

{{IS_NOTE

	Authors:	Tom M. Yeh
	Contributors:
	Create Date:	8/14/0 05:42PM
	$Header: /cvsroot/jedi/include/jedi/time.h,v 1.3 2000/09/27 04:05:00 tomyeh Exp $
	Purpose:	Date/Time functions
	Description:
	
}}IS_NOTE

Copyright (C) 2000 Infoshock Corporation. All Rights Reserved.

{{IS_RIGHT
}}IS_RIGHT
*/
#ifndef _is_jedi_time_H
#define _is_jedi_time_H

///////////////////////////////////////////////////////////
typedef struct TDateTime {
	__s16 second;
	__s16 minute;
	__s16 hour;
	__s16 day;
	__s16 month;
	__s16 year;
	__s16 weekDay; //Days since Sunday (0 to6)
} TDateTime;

typedef struct TTime {
	__u8 hours;
	__u8 minutes;
} TTime;

typedef struct TDate {
	__u16 _BF3(
		year :7, //years since 1904 (Mac format)
		month:4,
		day :5);
} TDate;

///////////////////////////////////////////////////////////
EXTERN_C void _AAPI AddDate(TDate* date, int diff);
EXTERN_C void _AAPI DaysToDate(unsigned days, TDate* date);
EXTERN_C void _AAPI SecondsToDate(unsigned secs, TDate* date);
EXTERN_C unsigned _AAPI DateToDays(TDate date);
//EXTERN_C void _AAPI dtToAscii(__u8 mon, __u8 day, __u16 year, int fmt, char* pStr);
//EXTERN_C void _AAPI dtToDOWDMFormat(__u8 mon, __u8 day, __u16 year, int fmt, char* pStr);
EXTERN_C int _AAPI DayOfMonth(int month, int day, int year);
EXTERN_C int _AAPI DayOfWeek(int month, int day, int year);
EXTERN_C int _AAPI DaysInMonth(int month, int year);

EXTERN_C void _AAPI AddDateTime(TDateTime* date, int diff);
EXTERN_C unsigned _AAPI DateTimeToSeconds(TDateTime* dt);
EXTERN_C void _AAPI SecondsToDateTime(unsigned secs, TDateTime* dt);
//EXTERN_C void _AAPI TimeToAscii (__u8 hours, __u8 minutes, int fmt, char* pString);

EXTERN_C unsigned _AAPI GetCurrentSeconds(void);
EXTERN_C void _AAPI SetCurrentSeconds(unsigned secs);
EXTERN_C unsigned _AAPI GetCurrentTicks(void);

///////////////////////////////////////////////////////////
//Extra API
EXTERN_C __u32 _JAPI ToSeconds(int year, int month, int day);

///////////////////////////////////////////////////////////
#include <os/time.h>

#endif //_is_jedi_time_H
