/*	thread.h

{{IS_NOTE

Authors:	Tom M. Yeh
Contributors:
Create Date:	7/11/0 09:12PM
$Header: /cvsroot/jedi/include/jedi/thread.h,v 1.25 2000/10/04 03:28:31 tomyeh Exp $
Purpose:	Thread Functions
Description:

}}IS_NOTE

Copyright (C) 2000 Infoshock Corporation. All Rights Reserved.

{{IS_RIGHT
}}IS_RIGHT
*/
#ifndef _is_jedi_thread_H
#define _is_jedi_thread_H

////////////////////////////////////////////////////////
struct TThdLocal;
typedef void _AAPI_PF(_thread_f)(void*);

#define SCHED_PRIORITY_TIME_CRITICAL	-3
#define SCHED_PRIORITY_HIGHEST			-2
#define SCHED_PRIORITY_ABOVE_NORMAL		-1
#define SCHED_PRIORITY_NORMAL			0
#define SCHED_PRIORITY_BELOW_NORMAL		1
#define SCHED_PRIORITY_LOWEST			2
#define SCHED_PRIORITY_ABOVE_IDLE		3
#define SCHED_PRIORITY_IDLE				4

////////////////////////////////////////////////////////
#include <os/thread.h>

////////////////////////////////////////////////////////
EXTERN_C __u32 _AAPI mtCreateThread(
	_thread_f entry, void* data, unsigned stackSize DEFAULTVAL(0));
	//Create a thread; return NULL if failed
	//If entry==AppThdFunc, it means create the main thread
	//of a new application

EXTERN_C void _AAPI mtExitThread(void);
	//Exit the current thread
EXTERN_C bool _AAPI mtKillThread(__u32 nThdId);
	//Terminate the specified thread

EXTERN_C bool _AAPI mtWaitThread(__u32 nThdId, unsigned toTicks DEFAULTVAL(TO_INFINITE));
	//Wait for a thread to complete; return true if completed
inline __u32 _JAPI mtGetCurrentThread(void);
	//returns a constant identifies a thread.

EXTERN_C bool _AAPI mtSetPriority(__u32 nThdId, int priority);
EXTERN_C int _AAPI mtGetPriority(__u32 nThdId);

EXTERN_C void _AAPI mtExitProcess(void);
	//Exit the current process
EXTERN_C __u32 _AAPI mtGetCurrentProcess(void);
	//returns a constant identifies an application

EXTERN_C bool _AAPI mtThreadActive(__u32 nThdId);
	//return true if a thread active

EXTERN_C void _JAPI mtAnakinYield(void);
EXTERN_C void _JAPI mtAnakinSleep(unsigned ticks);
	//Jedi codes shall not call these functions. They are for applications.
	//Instead, Jedi codes shall use mtJediYield and mtJediSleep

EXTERN_C void _JAPI mtJediYield(void);
EXTERN_C void _JAPI mtJediSleep(unsigned ticks);
	//Yield/Sleep for Jedi codes. They invoke AnakinUnlock before enterring
	//waiting state, and re-gain the lock before return

////////////////////////////////////////////////////////
//Platform-depedent part; called internally
//Note: OS uses _handle_t while Jedi uses __u32 to identify a thread
EXTERN_C _handle_t _JAPI mtOsCreateThread(_osthread_f entry, void* data, unsigned stackSize, __u32* pThdId);
EXTERN_C __u32 _JAPI mtOsGetCurrentThreadId();
EXTERN_C void _JAPI mtOsExitThread(void);
	//Note: AnakinUnlock is called before mtOsExitThread is called.
EXTERN_C void _JAPI mtOsKillThread(_handle_t hThd);
EXTERN_C void _JAPI mtOsDetachThread(_handle_t hThd);
	//Detach the thread and the caller no longer has the control
	//of the specified thread, i.e., you cannot access hThd any more.
	//It is important to close the hand
EXTERN_C bool _JAPI mtOsWaitThread(_handle_t hThd, unsigned toTicks);
	//Wait for a thread to complete; return true if its done

EXTERN_C bool _JAPI mtOsSetPriority(_handle_t hThd, int priority);
EXTERN_C int _JAPI mtOsGetPriority(_handle_t hThd);

EXTERN_C void _JAPI mtOsNotifyNoApp(void);
	//called when the last process is exiting
	//It does not really depend on OS but different OS might process
	//it differently for better UI.

////////////////////////////////////////////////////////
//Synchronization
EXTERN_C void _JAPI mtInitMutex(_mutex_t* mutex);
EXTERN_C void _JAPI mtDestroyMutex(_mutex_t* mutex);
EXTERN_C void _AAPI mtLockMutex(_mutex_t* mutex);
EXTERN_C void _AAPI mtUnlockMutex(_mutex_t* mutex);

EXTERN_C void _JAPI mtInitCond(_cond_t* cond, _mutex_t* mutex, bool bBroadcast DEFAULTVAL(false));
EXTERN_C void _JAPI mtDestroyCond(_cond_t* cond);
EXTERN_C void _JAPI mtSetCond(_cond_t* cond);
	//Note: whether one or all threads, waiting this cond, are wakened
	//depend on bBroadcast of mtInitCond. In other words, 
	//unlike Unix, it decides at the beginning
EXTERN_C bool _AAPI mtWaitCond(_cond_t* cond, unsigned toTicks DEFAULTVAL(TO_INFINITE));
	//return true if succeed; false if timeout

////////////////////////////////////////////////////////
//Thread Local Storage
EXTERN_C unsigned _JAPI mtAllocTls(void);
EXTERN_C BOOL _JAPI mtFreeTls(unsigned index);
EXTERN_C void* _JAPI mtGetTls(unsigned index);
EXTERN_C BOOL _JAPI mtSetTls(unsigned index, void* val);

////////////////////////////////////////////////////////
#ifdef __cplusplus
class CMutex {
public:
	CMutex() {mtInitMutex(&m_mutex);}
	~CMutex() {mtDestroyMutex(&m_mutex);}

	void Lock() {mtLockMutex(&m_mutex);}
	void Unlock() {mtUnlockMutex(&m_mutex);}

	_mutex_t* Mutex() {return &m_mutex;}

	_mutex_t m_mutex;
};

class CCond {
public:
	CCond(CMutex* mutex, bool bBroadcast DEFAULTVAL(false)) {mtInitCond(&m_cond, &mutex->m_mutex, bBroadcast);}
	CCond(_mutex_t* mutex, bool bBroadcast DEFAULTVAL(false)) {mtInitCond(&m_cond, mutex, bBroadcast);}
	~CCond() {mtDestroyCond(&m_cond);}

	int Wait(unsigned toTicks DEFAULTVAL(TO_INFINITE)) {return mtWaitCond(&m_cond, toTicks);}
	void Set() {mtSetCond(&m_cond);}

	void Lock() {Wait();}
	void Unlock() {Set();}

	_cond_t m_cond;
};

////////////////////////////////////////////////////////
extern CMutex g_sysMutex;
	//the mutex to control only one thread is allowed to enter Anakin API
	//See http://10.1.3.2/rd/project/jedi/impl-note.html#Multi-thread%20Issues

#endif __cplusplus

////////////////////////////////////////////////////////
EXTERN_C void AnakinLock(); //g_sysMutex.Lock()
EXTERN_C void AnakinUnlock(); //g_sysMutex.Unlock90

////////////////////////////////////////////////////////
struct TExInfo;
struct TWin;

//TAppLocal: Per-app data
typedef struct TAppLocal {
	TAppLocal	*next;
	TThdLocal	*pThdLocal;	//point to the local of the first thread
		//Note: the thread pointed by pThdLocal is also the main thread

	void		*pFormExList;	//a list of TFormEx
	void		*pMenubarExList;	//a list of TMenubarEx
	void		*pBmpExList;		//a list of TBmpEx
	void		*pDBRefExList;		//a list of TDBRef

	char 		prcNext[MAX_DB_NAME_LEN];
				//indicate the next application to run
} TAppLocal;

//TThdLocal: Per-thread data
typedef struct TThdLocal {
	TThdLocal	*next;
	TAppLocal	*pAppLocal;
	_handle_t	hThd;
	__u32		nId;
	__u32		nIdOwner; //who creates this thread

	TExInfo		*exInfo;
	void		*stack; //point to the 'beginning' for the stack

	void 		*pDrawStateExList; //a list of TDrawStateEx
	TWin		*pWinDraw; //the draw window for each thread

	bool IsMainThread() const {return this==pAppLocal->pThdLocal;}
} TThdLocal;

inline TThdLocal* _JAPI GetThdLocal() {
	extern unsigned g_thdLocalIndex;
	return (TThdLocal*)mtGetTls(g_thdLocalIndex);
}
inline TAppLocal* _JAPI GetAppLocal() {return GetThdLocal()->pAppLocal;}

////////////////////////////////////////////////////////
inline __u32 _JAPI mtGetCurrentThread(void) {return GetThdLocal()->nId;}

////////////////////////////////////////////////////////
//Internal Functions
EXTERN_C void _JAPI AppCleanup(TAppLocal* app, bool bExitThread);
	//Cleanup the specified process
	//If app==0, the current process is used
	//If bExitThread true, the thread will exit if app==GetAppLocal()
	//Specify bExitThread only if we want to stop an application earlier
EXTERN_C void _JAPI AppLaunchCleanup(TAppLocal* app, __u32 nIdOwner);
	//Cleanup all threads but preserve the main thread, so we can reuse
	//it for a new process (for performance reason)
	//If nIdOwner is not zero, only threads owned by nIdOwner are cleaned
	//If app==0, the current process is used
EXTERN_C void _JAPI ThdCleanup(TThdLocal* thd, bool bDetach=true);
	//Cleanup the specified thread
	//thd cannot be null.
	//If bDetach is true, thd is detached from the list and deleted.
#endif //_is_jedi_thread_H
