/*	swab.h

{{IS_NOTE

	Authors:	Henri Chen, Tom M. Yeh
	Contributors:
	Create Date:	2000/7/11 09:14PM
	$Header: /cvsroot/jedi/include/jedi/swab.h,v 1.5 2000/07/17 04:20:33 tomyeh Exp $
	Purpose:	Swap byte order between little and big endian for general case
	Description:

}}IS_NOTE

Copyright (C) 2000 Infoshock Corporation. All Rights Reserved.

{{IS_RIGHT
}}IS_RIGHT
*/
#ifndef _is_jedi_swab_H
#define _is_jedi_swab_H

////////////////////////////////////////////////////////////
#define __swab16	i_swab16
inline __u16 i_swab16(__u16 x)
{
	return	(__u16)(((((__u16)x) & (__u16)0x00ffU) << 8) | 
					((((__u16)x) & (__u16)0xff00U) >> 8));
}

#define __swab32	i_swab32
inline __u32 i_swab32(__u32 x)
{
	return	((((__u32)x) & (__u32)0x000000ffUL) << 24) |
			((((__u32)x) & (__u32)0x0000ff00UL) <<  8) |
			((((__u32)x) & (__u32)0x00ff0000UL) >>  8) |
			((((__u32)x) & (__u32)0xff000000UL) >> 24);
}

#define __swab64	i_swab64
inline __u64 i_swab64(__u64 x)
{
	return
		(__u64)((((__u64)x) & (__u64)__u64_c(0x00000000000000ff)) << 56) |
		(__u64)((((__u64)x) & (__u64)__u64_c(0x000000000000ff00)) << 40) |
		(__u64)((((__u64)x) & (__u64)__u64_c(0x0000000000ff0000)) << 24) |
		(__u64)((((__u64)x) & (__u64)__u64_c(0x00000000ff000000)) <<  8) |
		(__u64)((((__u64)x) & (__u64)__u64_c(0x000000ff00000000)) >>  8) |
		(__u64)((((__u64)x) & (__u64)__u64_c(0x0000ff0000000000)) >> 24) |
		(__u64)((((__u64)x) & (__u64)__u64_c(0x00ff000000000000)) >> 40) |
		(__u64)((((__u64)x) & (__u64)__u64_c(0xff00000000000000)) >> 56);
}

////////////////////////////////////////////////////////////
// give the bit position of the opposite endian
#define __swap_bitof32	i_swap_bitof32
inline __u8 i_swap_bitof32(__u8 x)
{
	ASSERT(x < 32);
	return (__u8)(x ^ 24);
}

////////////////////////////////////////////////////////////
#include <cpu/swab.h>

////////////////////////////////////////////////////////////
#ifdef __LITTLE_ENDIAN__	//cpu is little endian

#define __cpu_to_le64(x) (x)
#define __le64_to_cpu(x) (x)
#define __cpu_to_le32(x) (x)
#define __le32_to_cpu(x) (x)
#define __cpu_to_le16(x) (x)
#define __le16_to_cpu(x) (x)

#define __cpu_to_be64(x) __swab64((x))
#define __be64_to_cpu(x) __swab64((x))
#define __cpu_to_be32(x) __swab32((x))
#define __be32_to_cpu(x) __swab32((x))
#define __cpu_to_be16(x) __swab16((x))
#define __be16_to_cpu(x) __swab16((x))

#define __cpu_to_be_bitof32(x)	__swap_bitof32(x)
#define	__be_bitof32_to_cpu(x)	__swap_bitof32(x)
#define	__cpu_to_le_bitof32(x)	(x)
#define	__le_bitof32_to_cpu(x)	(x)

#else	//__LITTLE_ENDIAN__	//cpu is big endian

#define __cpu_to_le64(x) __swab64((x))
#define __le64_to_cpu(x) __swab64((x))
#define __cpu_to_le32(x) __swab32((x))
#define __le32_to_cpu(x) __swab32((x))
#define __cpu_to_le16(x) __swab16((x))
#define __le16_to_cpu(x) __swab16((x))

#define __cpu_to_be64(x) (x)
#define __be64_to_cpu(x) (x)
#define __cpu_to_be32(x) (x)
#define __be32_to_cpu(x) (x)
#define __cpu_to_be16(x) (x)
#define __be16_to_cpu(x) (x)

#define __cpu_to_be_bitof32(x)	(x)
#define	__be_bitof32_to_cpu(x)	(x)
#define	__cpu_to_le_bitof32(x)	__swap_bitof32(x)
#define	__le_bitof32_to_cpu(x)	__swap_bitof32(x)

#endif	//__LITTLE_ENDIAN__

#endif //_is_jedi_swab_H
