/*	smartptr.hpp

{{IS_NOTE

	Authors:	Henri Chen
	Contributors:
	Create Date:	2000/9/29 09:56AM
	$Header: $
	Purpose:	
	Description:	Smart Pointer, adpated from GARRET's smart pointer

}}IS_NOTE

Copyright (C) 2000 Infoshock Corporation. All Rights Reserved.

{{IS_RIGHT
}}IS_RIGHT
*/
#ifndef _is_minidb_smartptr_H
#define _is_minidb_smartptr_H

template<class T>
class RamPtr { //	RAM	pointer
private:
	T*	 Addr;
	
	void Reset() {Addr= (T*)(&Odb_Nil_Ptr + 1);}
	void Fix()	 {Odb_Get(Addr)->Fix();}
	void UnFix() {Odb_Get(Addr)->UnFix();}
	void Init(T const*	A) {if (A) {Addr= (T*)A; Fix();} else Reset();}
	
public:
	friend	bool Nil( RamPtr const& P ) {return P.Addr == (T*)(&Odb_Nil_Ptr + 1);}
	operator T*() const {return Nil(*this) ? NULL : Addr;}
	T*	 operator->() const { return operator T*(); }
	T&	 operator*() const 	{ return *Addr; }
	bool operator!() const 	{ return Nil(*this);}
	void operator=(T const* A) { if (!Nil(*this)) UnFix(); Init(A); }
	void operator=(RamPtr const& P) {operator=(P.operator T*());}
	bool operator==(RamPtr const& P) const { return Addr == P.Addr; }
	bool operator!=(RamPtr const& P) const { return Addr != P.Addr; }
	
	RamPtr() {Reset();}
	RamPtr(RamPtr const& P) { Addr=P.Addr; Fix();}
	RamPtr(T const* A) { Init(A); }
	~RamPtr() { if (!Nil(*this)) UnFix(); }
};

template<class	T>
class DbPtr {
private:
	void* Addr;	//db address, not ram address

	void Init(T const* A) {Addr= A ? (void*)(Odb_Get(A)->Address) : NULL;}

public:
	friend bool Nil(DbPtr const& P ) { return P.Addr == NULL;	}
	operator T*() const {return Nil(*this) ? NULL :
		((T*)Object_Database::Default->Find(large(Addr))); }
	T* operator->() const {return operator	T*();}
	void operator=(T const* A) { Init(A);}
	bool operator == (DbPtr const& P) const { return Addr == P.Addr; }
	bool operator != (DbPtr const& P) const { return Addr != P.Addr; }
	unsigned long DbAddr() const {return (unsigned long) ((char*)Addr-(char*)0); }

	DbPtr() : Addr(0) {}
	DbPtr( DbPtr const& P ) { Addr= P.Addr; }	
	DbPtr( T const* A ) { Init(A); }

	static DbPtr Root()
  	{ DbPtr P; P.Addr= Object_Database::Default->Start(); return P;}
};

#endif //_is_minidb_smartptr_H
