/*	rct.h

{{IS_NOTE

	Authors:	Henri Chen
	Contributors:
	Create Date:	2000/7/24 08:51PM
	$Header: /cvsroot/jedi/include/jedi/rct.h,v 1.3 2000/08/31 09:50:17 tomyeh Exp $
	Purpose:	
	Description:	Implementation Header of Jedi's rctXXX()

}}IS_NOTE

Copyright (C) 2000 Infoshock Corporation. All Rights Reserved.

{{IS_RIGHT
}}IS_RIGHT
*/
#ifndef _is_jedi_rct_H
#define _is_jedi_rct_H

//////////////////////////////////////////////////////////
//TRect is defined in jedi/types.h

//////////////////////////////////////////////////////////
EXTERN_C void _AAPI rctCopy(const TRect *pSrcRect, TRect *pDstRect);
	//Copy rectangle from source to destination
EXTERN_C bool _AAPI rctPtInRect(__s16 x, __s16 y, const TRect *pRect);
	//Check if a point(x,y) is inside a rectangle
EXTERN_C bool _AAPI rctIntersect(const TRect *pSrcRect1, const TRect *pSrcRect2, TRect *pDstRect);
	//Intersect two source rectangles and return results in destination
EXTERN_C void _AAPI rctSet(TRect *pRect, __s16 left, __s16 top, __s16 width, __s16 height);
	//Set the rectangle's dimension
EXTERN_C void _AAPI rctInset(TRect *pRect, __s16 insetAmt);
	//Shrink(insetAmt is positive) or enlarge(insetAmt is negative) the rectangle
EXTERN_C void _AAPI rctOffset(TRect *pRect, __s16 deltaX, __s16 deltaY);
	//Move a rectangel with specified offset.

#endif //_is_jedi_rct_H
