/*	rbtree.h

{{IS_NOTE

	Authors:	Henri Chen
	Contributors:
	Create Date:	2000/9/28 08:05PM
	$Header: $
	Purpose:	
	Description:	Implementation of rbtree
	
}}IS_NOTE

Copyright (C) 2000 Infoshock Corporation. All Rights Reserved.

{{IS_RIGHT
}}IS_RIGHT
*/
#ifndef _is_minidb_rbtree_H
#define _is_minidb_rbtree_H

class CRBNode : public File_Object {
public:
	CRBNode() : m_data(NULL), m_left(NULL), m_right(NULL), m_flags(0) {}
	void Set(unsigned mask, bool bSet);
	inline bool IsSet(unsigned mask);
	inline bool IsRed(void);
	inline bool IsBlack(void);
	inline void SetColor(bool bRed);
	inline void SetRed(void);
	inline void SetBlack(void);
	inline void SetRight(CRBNode* r);
	inline void SetLeft(CRBNode* l);
	inline void SetData(File_Object* data);
	inline RamPtr<File_Object> GetData(void);
	
	//data
	DbPtr<File_Object>	m_data;
	DbPtr<CRBNode> 		m_left, m_right;
	unsigned 			m_flags;
};

//CRBNode.m_flags
#define	RBNODEFLAGS_RED	0x1

inline bool CRBNode::IsSet(unsigned mask)
{
	return (m_flags & mask) != 0;
}

inline bool CRBNode::IsRed(void)
{
	return IsSet(RBNODEFLAGS_RED);
}

inline bool CRBNode::IsBlack(void)
{
	return !IsRed();
}

inline void CRBNode::SetColor(bool bRed)
{
	Set(RBNODEFLAGS_RED, bRed);
}

inline void CRBNode::SetRed(void)
{
	SetColor(true);
}

inline void CRBNode::SetBlack(void)
{
	SetColor(false);
}

inline void CRBNode::SetLeft(CRBNode* l)
{
	m_left= l;
	Modify();
}

inline void CRBNode::SetRight(CRBNode* r)
{
	m_right= r;
	Modify();
}

inline void CRBNode::SetData(File_Object *d)
{
	m_data= d;
	Modify();
}

inline RamPtr<File_Object> CRBNode::GetData(void)
{
	return (File_Object*)m_data;
}

//////////////////////////////////////////////////////////////////
typedef void (*_copy_ft)(CRBNode*,CRBNode*);
typedef int (*_comp_ft)(void *key, CRBNode*);
class CRBTree : public File_Object {
public:
	inline CRBTree();
	inline void FuncBind(_copy_ft, _comp_ft);
	void Attach(CRBNode *, void *key);
		//attach a node onto the tree.
	void Detach(RamPtr<CRBNode> *pDelNode, void* key);
		//detach a node from the tree. If not found, return NULL.
	void Search(RamPtr<CRBNode> *pFoundNode, void* key);
		//search a node in the tree. If not found, return NULL.

	inline unsigned long GetNum(void);
	
#ifndef NDEBUG
	bool Check(void);
	bool CheckNode(CRBNode *, RamPtr<CRBNode> , unsigned *bn);
	void Dump(void (*printKey)(CRBNode*));
	void PrintNode(RamPtr<CRBNode> x, int level, int pos, void (*printKey)(CRBNode*));
#endif	//!NDEBUG
		
protected:
	void LeftRotate(CRBNode* pa, CRBNode* x);
	void RightRotate(CRBNode* pa, CRBNode* x);
	void Insert(RamPtr<CRBNode> root, CRBNode* z, void *key, CRBNode *ggpa, CRBNode *gpa, CRBNode *pa, CRBNode **nextX);
	void InsertFix(CRBNode* ggpa, CRBNode* gpa, CRBNode* pa, CRBNode* x, CRBNode **nextX);
	void Delete(RamPtr<CRBNode> root, void *key, CRBNode *gpa, CRBNode *pa, CRBNode **nextX, RamPtr<CRBNode> *pDelNode);
	void DeleteFix(CRBNode* gpa, CRBNode* pa, CRBNode* x, CRBNode **nextX, bool bLeft);
	inline void SetRoot(CRBNode* n);
	inline void IncNum(void);
	inline void DecNum(void);
	
	//data
	DbPtr<CRBNode>	m_root;
	unsigned long	m_num;
	void (*Copy)(CRBNode*,CRBNode*);
	int(*Comp)(void *key, CRBNode*);
};

typedef void (CRBTree::*_rotate_ft)(CRBNode* pa, CRBNode* x);
static void dummyCopy(CRBNode* , CRBNode* )
{
}

static int dummyComp(void* , CRBNode* )
{
	return 0;
}

inline void CRBTree::FuncBind(void (*cpy)(CRBNode*,CRBNode*), int(*cmp)(void *key, CRBNode*))
{
	Copy= cpy;
	Comp= cmp;
}

inline CRBTree::CRBTree() : m_root(NULL)
{
	FuncBind(&dummyCopy, &dummyComp);
}

inline void CRBTree::IncNum(void)
{
	m_num++;
	Modify();
}

inline void CRBTree::DecNum(void)
{
	m_num--;
	Modify();
}

inline unsigned long CRBTree::GetNum(void)
{
	return m_num;
}
inline void CRBTree::SetRoot(CRBNode* n)
{
	m_root= n;
	Modify();
}
#endif //_is_lib_rbtree_H
