/*	palmdb.h

{{IS_NOTE

	Authors:	Henri Chen
	Contributors:
	Create Date:	2000/9/7 08:00PM
	$Header: /cvsroot/jedi/include/jedi/palmdb.h,v 1.2 2000/09/19 10:20:53 henrichen Exp $
	Purpose:	
	Description:	Apply Palm's file onto Jedi's file db system

}}IS_NOTE

Copyright (C) 2000 Infoshock Corporation. All Rights Reserved.

{{IS_RIGHT
}}IS_RIGHT
*/
#ifndef _is_jedi_palmdb_H
#define _is_jedi_palmdb_H
class CPalmFile;
class CPalmJdbFile : public CJdbFile {
public:
	bool Create(const char *name, __u32 type, __u32 creator, bool bRes);
		//create a brand new jdb file
	bool ReadPalmDBHeader(TDbHeader *dbhdr);
		//read the palm's db header
	bool CreateFromPalmFile(const char *name);
		//given a palm file, create an associated jdb file
	bool CopyBlock(CPalmFile *prc, unsigned long offPrc, unsigned long offJdb, size_t sz);
		//copy data from palm file to this file
	bool ReadPrcChunk(TPrcChunk *pc, unsigned long off);
	bool ReadPdbChunk(TPdbChunk *pc, unsigned long off);
};

class CPalmDB : public CFileDB {
public:
	CPalmDB() : CFileDB(&m_palmJdbFile) {}
	bool Open(const char *filename, int mode);
	bool Create(__u16 cardNo, const char *name, __u32 type, __u32 creator, bool bRes);

	inline int Search(__u32 type, __u16 id);
	inline bool ReadPalmDBHeader(TDbHeader *dbhdr);
	
#ifndef NDEBUG
	void Dump(void);
	void DumpPrcRecord(unsigned numRecord);
	void DumpPdbRecord(unsigned numRecord);
#endif		
	//data
	CPalmJdbFile m_palmJdbFile;

protected:
	Traverse(unsigned idx, __u32 type, __u16 id, unsigned baseKey);
};

inline bool CPalmDB::ReadPalmDBHeader(TDbHeader *dbhdr)
{
	ASSERT(IsOpened());
	return m_palmJdbFile.ReadPalmDBHeader(dbhdr);
}

inline int CPalmDB::Search(__u32 type, __u16 id)
{
	return Traverse(m_jdxFile.GetArrayChunkRoot(), type, id, 0);
}

#endif //_is_jedi_palmdb_H
